//--------------------------------------------------------------
// FIR filter: Even order, Symmetric structure of direct form
//
// Copyright (c) 2014 MIKAMI, Naoki,  2014/06/20 
//--------------------------------------------------------------

#include "mbed.h"
#include "AdcInternal.hpp"
#include "MCP4922Single.hpp"
#include "coefficientsSym_200.hpp"
#include "FIR_Symmetry.hpp"

using namespace Mikami;

// sampling frequency
const float FS_ = 10.0e3f;

Adc adc_(A0);
Dac dacA_(Dac::DAC_A);
Ticker timer_;           // for timer interrupt

FirSymmetry<ORDER_> lpf(hm_);

void TimerIsr()
{
    float xn = adc_.Read(); // input

    // Execute FIR filter
    float yn = lpf.Execute(xn);

    dacA_.Write(yn);        // output
}

int main()
{
    timer_.attach_us(&TimerIsr, 1.0e6f/FS_);

    while (true) {}    // infinite loop
}

