//--------------------------------------------------------------
// FIR filter ---- Symmetry structure
// Copyright (c) 2014 MIKAMI, Naoki, 2014/06/20
//--------------------------------------------------------------

#ifndef FIR_SYMMETRY_HPP
#define FIR_SYMMETRY_HPP

#include "mbed.h"
#include "FirBaseClass.hpp"

namespace Mikami
{
    template<int order> class FirSymmetry : public FirBase<order>
    {
    public:
        using FirBase<order>::xn_;

        FirSymmetry(const float hk[]) : FirBase<order>(hk) {}

        virtual float Execute(float xin)
        {
            xn_[0] = xin;

            float acc = hm_[order/2]*xn_[order/2];
            for (int k=0; k<order/2; k++)
                acc = acc + hm_[k]*(xn_[k] + xn_[order-k]);

            FirBase<order>::Move();
                
            return acc;
        }
    };
}
#endif  // FIR_SYMMETRY_HPP

