//--------------------------------------------------------------
// Virtual base class for FIR filter
// Copyright (c) 2014 MIKAMI, Naoki, 2014/06/22
//--------------------------------------------------------------

#ifndef FIR_BASE_HPP
#define FIR_BASE_HPP

#include "mbed.h"

namespace Mikami
{
    template<int order> class FirBase
    {
    private:
        FirBase(const FirBase&);
        FirBase& operator=(const FirBase&);
    protected:
        const float *const hm_; // pointer for filter coefficients
        float xn_[order+1];     // buffer for inputs

        // Constructor
        FirBase(const float hk[]) : hm_(hk) { Clear(); }
        
        // Execute filter
        virtual float Execute(float xin) = 0;

        // Move signals in xn_[]
        void Move()
        {
            for (int k=order; k>0; k--)
                xn_[k] = xn_[k-1];  // move input signals
        }
    public:
        void Clear()
        {
            for (int k=0; k<=order; k++) xn_[k] = 0.0;
        }
    };
}
#endif  // FIR_BASE_HPP
