//--------------------------------------------------------------
// FIR filter: Even order, Direct form
//
// Copyright (c) 2014 MIKAMI, Naoki,  2014/07/15 
//--------------------------------------------------------------

#include "mbed.h"
#include "AdcInternal.hpp"
#include "MCP4922Single.hpp"
#include "coefficients_200.hpp"
#include "FIR_Direct.hpp"

using namespace Mikami;

// sampling frequency
const float FS_ = 10.0e3f;

// for AD converter
Adc adc_(A0);
// for DA converter
Dac dacA_(Dac::DAC_A);

Ticker timer_;           // for timer interrupt
DigitalOut pinD8_(D8);   // for measurement of execution time

FirDirect<ORDER_> lpf(hm_);

// Called every 0.1 ms
void TimerIsr()
{
    float xn = adc_.Read(); // input

    // Execute FIR filter
    float yn = lpf.Execute(xn);

    dacA_.Write(yn);        // output
}

int main()
{
    timer_.attach_us(&TimerIsr, 1.0e6f/FS_);

    while (true) {}    // infinite loop
}
