//--------------------------------------------------------------
// FIR filter ---- Direct structure
// copyright (c) 2014 MIKAMI, Naoki, 2014/06/20
//--------------------------------------------------------------

#ifndef FIR_DIRECT_HPP
#define FIR_DIRECT_HPP

#include "mbed.h"
#include "FirBaseClass.hpp"

namespace Mikami
{
    template<int order> class FirDirect : public FirBase<order>
    {
    public:
        using FirBase<order>::xn_;
        
        FirDirect(const float hk[]) : FirBase<order>(hk) {}
        
        virtual float Execute(float xin)
        {
            xn_[0] = xin;

            float acc = 0;
            for (int k=0; k<=order; k++)
                acc = acc + hm_[k]*xn_[k];

            FirBase<order>::Move();

            return acc;
        }
    };
}
#endif  // FIR_DIRECT_HPP

