//-------------------------------------------------------------------
// FFT class for real data (Header)
// Copyright (c) 2014 MIKAMI, Naoki,  2014/06/29
//-------------------------------------------------------------------

#ifndef FFT_REAL_HPP
#define FFT_REAL_HPP

#include "mbed.h"
#include <complex>  // requisite

namespace Mikami
{
    typedef complex<float> Complex; // define "Complex"

    class FftReal
    {
    private:
        const int N_FFT_;
        Complex*  wTable_;    // twiddle factor
        uint16_t* bTable_;    // for bit reversal
        Complex*  u_;         // working area

        FftReal(const FftReal& );
        FftReal& operator=(const FftReal& );

    public:
        // Constructor
        explicit FftReal(uint16_t n);
        // Destructor
        ~FftReal();
        // Execute FFT
        void Execute(const float x[], Complex y[]);
    };
}
#endif  // FFT_REAL_HPP

