//--------------------------------------------------------------
// Echo generation system
// Copyright (c) 2014 MIKAMI, Naoki,  2014/08/24
//--------------------------------------------------------------

#include "mbed.h"
#include "AdcInternal.hpp"
#include "MCP4922Single.hpp"
#include "ReverbUnit.hpp"

using namespace Mikami;

const float FS_ = 10.0e3f;
Adc adc_(A0);
Dac dac_(Dac::DAC_A);

Ticker timer_;           // for timer interrupt

const float G_C_ = 0.8f;
const float G_A_ = 0.6f;
const float G0_ = 1.0f - G_C_;
CombFilter<887>    cmF1(G_C_);
CombFilter<1153>   cmF2(G_C_);
CombFilter<1499>   cmF3(G_C_);
AllPassFilter<97>  apF1(G_A_);
AllPassFilter<131> apF2(G_A_);

void TimerIsr()
{
    float xn = adc_.Read(); // input

    xn = G0_*xn;
    float yn = cmF1.Execute(xn) + cmF2.Execute(xn)
             + cmF3.Execute(xn);
    yn = apF2.Execute(apF1.Execute(yn));
    yn = yn + xn;   // add direct input signal
    
    dac_.Write(yn);        // output
}

int main()
{
    timer_.attach_us(&TimerIsr, 1.0e6f/FS_);
    while (true) {}    // infinite loop
}
