//------------------------------------------------------
// Class for 1 DAC in MCP4922 -- Header
//
// Default pin assign
//      D11  SPI Master Out Slave In
//      D13  SPI Serial Clock
//      D10  SPI Slave Select
//      D9   to MCP9922 LDAC pin
//
// Copyright (c) 2014 MIKAMI, Naoki,  2014/06/18
//------------------------------------------------------

#ifndef MCP4922_SINGLE_HPP
#define MCP4922_SINGLE_HPP

#include "mbed.h"

namespace Mikami
{
    class Dac
    {
    public:
        enum DAC { DAC_A = 0, DAC_B = 0x8000 };

        // Constructor
        Dac(DAC dac,
            PinName mosi = SPI_MOSI,  // D11
            PinName sclk = SPI_SCK,   // D13
            PinName cs   = SPI_CS,    // D10
            PinName ldac = D9,        // D9
            int hz = 20000000);

        // -1.0f <= value <= 1.0f
        void Write(float value);
        // 0 <= value <= 4095
        void Write(uint16_t value);
        
        // generate LDAC pulse
        void Ldac();

    private:
        uint16_t wcr_;    // write command register
        SPI mySpi_;       // SPI object
        DigitalOut myCs_; // for chip select
        DigitalOut myLd_; // for LDAC

        Dac(const Dac&);
        Dac& operator=(const Dac&);
        
        // for use internally
        void WriteDac(uint16_t value);
    };
}
#endif  // MCP4922_SINGLE_HPP
