//------------------------------------------------------
// Class for 2 DACs in MCP4922
//
// Copyright (c) 2014 MIKAMI, Naoki,  2014/06/18
//------------------------------------------------------

#include "MCP4922Dual.hpp"

namespace Mikami
{
    DacDual::DacDual(PinName mosi, PinName sclk, PinName cs,
                     PinName ldac, int hz)
        : dacA_(Dac::DAC_A, mosi, sclk, cs, ldac, hz),
          dacB_(Dac::DAC_B, mosi, sclk, cs, ldac, hz)
    {
        Write((uint16_t)0, (uint16_t)0);
    }
    
    void DacDual::Write(float valueA, float valueB)
    {
        dacA_.Write(valueA);
        dacB_.Write(valueB);
        dacB_.Ldac();
    }

    void DacDual::Write(uint16_t valueA, uint16_t valueB)
    {
        dacA_.Write(valueA);
        dacB_.Write(valueB);
        dacB_.Ldac();
    }
}
