//------------------------------------------------------
// Class for 1 DAC in MCP4922
//
// Copyright (c) 2014 MIKAMI, Naoki,  2014/06/18
//------------------------------------------------------

#include "MCP4922Single.hpp"

namespace Mikami
{
    Dac::Dac(DAC dac, PinName mosi, PinName sclk,
             PinName cs, PinName ldac, int hz)
        : wcr_(dac | 0x3000), mySpi_(mosi, NC, sclk),
          myCs_(cs, 1), myLd_(ldac, 0)
    {
        // Set SPI format and bus frequency
        mySpi_.format(16, 0);
        mySpi_.frequency(hz);

        // Set DAC to 0
        WriteDac(0);
    }

    void Dac::Write(float value)
    {
        if (value < -1.0f) value = -1.0f;
        if (value >  1.0f) value =  1.0f;

        WriteDac((uint16_t)((value + 1.0f)*2047));
    }

    void Dac::Write(uint16_t value)
    {
        WriteDac((value > 4095) ? 4095 : value);
    }
        
    void Dac::Ldac()
    {
        myLd_.write(0);
        wait_us(1);       
        myLd_.write(1);
    }

    void Dac::WriteDac(uint16_t value)
    {
        myCs_.write(0); // cs <= L
        mySpi_.write(value | wcr_);
        myCs_.write(1); // cs <= H
    }
}
