//------------------------------------------------------
// Class for 2 DACs in MCP4922
//
// Copyright (c) 2014 MIKAMI, Naoki,  2014/06/18
//------------------------------------------------------

#ifndef MCP4922_DUAL_HPP
#define MCP4922_DUAL_HPP

#include "mbed.h"
#include "MCP4922Single.hpp"

namespace Mikami
{
    class DacDual
    {
    public:
        // Constructor
        DacDual(PinName mosi = SPI_MOSI,  // D11
                PinName sclk = SPI_SCK,   // D13
                PinName cs   = SPI_CS,    // D10
                PinName ld   = D9,        // D9
                int hz = 20000000);

        // -1.0f <= valueA, valueB <= 1.0f
        void Write(float valueA, float valueB);
        // 0 <= valeuA, valueB <= 4095
        void Write(uint16_t valueA, uint16_t valueB);

    private:
        Dac dacA_;
        Dac dacB_;
        
        DacDual(const DacDual&);
        DacDual& operator=(const DacDual&);
    };
}
#endif  // MCP4922_DUAL_HPP

