//----------------------------------------------------------------------
//  縦続形II IIR フィルタ，float 型を使用
//
//  2022/01/19, Copyright (c) 2022 MIKAMI, Naoki
//----------------------------------------------------------------------

#include "MultirateLiPh.hpp"
#include "IirCascade.hpp"
#include "Coefs_IIR6_Cascade_LP_300.hpp"
#pragma diag_suppress 870   // マルチバイト文字使用の警告抑制のため
using namespace Mikami;

const float FS_ = 10.0f;    // 入力の標本化周波数： 10 kHz
MultirateLiPh myAdDa_(FS_); // 出力標本化周波数を４倍にするオブジェクト
IirCascade df_(ORDER_, CK_, G0_);

// ADC 変換終了割込みに対する割込みサービス･ルーチン
void AdcIsr()
{
    float xn = myAdDa_.Input(); // 入力
    float yn = df_.Execute(xn); // 縦続形 IIR フィルタの処理
    myAdDa_.Output(yn);         // 出力
}

int main()
{
    printf("\r\n縦続形 IIR フィルタを実行します\r\n");

    myAdDa_.Start(&AdcIsr);     // 標本化を開始する
    while (true) {}
}