//---------------------------------------------------
//  縦続形 IIR フィルタ
//
//  2022/01/18, Copyright (c) 2022 MIKAMI, Naoki
//---------------------------------------------------

#include "Biquad.hpp"
#include "Array.hpp"    // Array クラスが定義されている
using Mikami::Array;

#ifndef IIR_CASCADE_HPP
#define IIR_CASCADE_HPP

class IirCascade
{
public:
    // コンストラクタ
    IirCascade(int order, const Biquad::Coefs ck[], float g0)
        : ORDER_(order), G0_(g0), hn_((order+1)/2)
    {
        for (int k=0; k<(order+1)/2; k++) hn_[k] = Biquad(ck[k]);
    }

    // フィルタ処理を実行する
    float Execute(float xn)
    {
        float yn = G0_*xn;
        for (int k=0; k<(ORDER_+1)/2; k++) yn = hn_[k].Execute(yn);
        return yn;
    }

private:
    const int ORDER_;   // 次数
    const float G0_;    // 利得定数
    Array<Biquad> hn_;  // Biquad クラスのオブジェクトの配列
};
#endif  // IIR_CASCADE_HPP