//-----------------------------------------------------
//  縦続形 IIR フィルタの次数と係数の定義
//      係数は float 型
//  2022/01/19, Copyright (c) 2022 MIKAMI, Naoki
//-----------------------------------------------------

#include "Biquad.hpp"

// 低域通過フィルタ
// 連立チェビシェフ特性
// 次数　　　　： 6 次
// 標本化周波数： 10.00 kHz
// 遮断周波数　：  0.30 kHz
// 通過域のリップル： 0.50 dB
// 阻止域の減衰量　：40.00 dB
const int ORDER_ = 6;               // 次数
const float G0_ = 9.900438E-03f;    // 利得定数

// Biquad クラスの構造体 Coefs の配列で定義
const Biquad::Coefs CK_[] = {
    { 1.854098E+00f, -8.646499E-01f, -1.672938E+00f, 1.0f},  // 1段目
    { 1.916727E+00f, -9.442058E-01f, -1.934754E+00f, 1.0f},  // 2段目
    { 1.952184E+00f, -9.878896E-01f, -1.953737E+00f, 1.0f}}; // 3段目