//--------------------------------------------------------------
// Example for using Adc and Dac classes
// Copyright (c) 2014 MIKAMI, Naoki, 2014/08/24
//--------------------------------------------------------------

#include "mbed.h"
#include "AdcInternal.hpp"
#include "MCP4922Single.hpp"

using namespace Mikami;

Adc adc_;
Dac dacA_(Dac::DAC_A);
Ticker timer_;

void TimerIsr()
{
    float value = adc_.Read();  // AD
    dacA_.Write(value);         // DA
}

int main()
{
    timer_.attach_us(&TimerIsr, 20);
    while (true) {}
}
