//--------------------------------------------------------------
//  Test program of DacDual class
//
//      Copyright (c) 2014 MIKAMI, Naoki, 2014/07/14
//--------------------------------------------------------------

#include "mbed.h"
#include "AdcInternal.hpp"
#include "MCP4922Dual.hpp"

using namespace Mikami;

const float FS_ = 10.0e3f;  // sampling frequency: 10 kHz

Adc adc_;       // default, input: A0
DacDual dacAB_; // object of DacDual class
Ticker timer_;  // for timer interrupt

// Called every 0.1 ms
void TimerIsr()
{
    float value = adc_.Read();  // AD
    
    // pin14 : Inphase 
    // pin10 : Out-of-phase
    dacAB_.Write(value, -value);
}

int main()
{
    timer_.attach_us(&TimerIsr, 1.0e6f/FS_);

    while (true) {} // infinite loop
}
