#include "mbed.h"
#include <math.h>  
#include "TSISensor.h"
#include "SLCD.h"

#define LEDON false
#define LEDOFF true
#define NUMBUTS 2
#define LBUT PTC12  // port addresses for buttons
#define RBUT PTC3
#define ARGUMENTSTATE 0
#define ANSWERSTATE 1
#define TSILIMIT 0.01
#define PRINTDELTA 0.01
#define LCDCHARLEN 10
#define DATAINTERVAL 0.1
#define BUTTONTIME 0.1
#define PROGNAME "kl46z_slider_mid_v1\n\r"

SLCD slcd; //define LCD display
Serial pc(USBTX, USBRX);

Timer dataTimer;
Timer ButtonTimer; // for reading button states
DigitalIn buttons[NUMBUTS] = {RBUT, LBUT};
float tsidata;
int displayState;

void initialize_global_vars(){
    pc.printf(PROGNAME);
    // set up DAQ timers
    ButtonTimer.start();
    ButtonTimer.reset();
    dataTimer.start();
    dataTimer.reset(); 
} 

void LCDMess(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
}

int main(void) {
    int i;
    char lcdData[LCDCHARLEN];
    float lastTouch = 0.0;
    TSISensor tsi;
    float tempTSI;
    PwmOut gled(LED_GREEN);
    PwmOut rled(LED_RED);
    
    initialize_global_vars();

     while (true) {
        if (ButtonTimer > BUTTONTIME){
            for (i=0; i<NUMBUTS; i++){ // index will be 0 or 1 
                if(!buttons[i]) { 
                    displayState = i; //set display state
                } // if ! buttons
            }// for loop to look at buttons  
            
        ButtonTimer.reset();
        }//end if buttonTimer
        
        //if statements to do stuff based off of display state
        
        //press right button - SELECT MODE (red led)
        if (displayState == 0){
            
            //turn on red led
            rled = 0.0;
            gled = 1.0;
            
            //send data to LCD
            //note that the tsidata read from the slider
            //only reads 2 digits past the decimal (i.e. 0.88)
            //as a percentage. Therefore, if we have the slider
            //reach a max value of 100, i do not think the slider
            //is precise enough to still be able to measure a value
            //as precise as 0.1 to use for a step.
            sprintf (lcdData,"%2.1f",tsidata*100 );  
            
        //if statement to read tsi
        if(dataTimer.read() > DATAINTERVAL){
            dataTimer.reset();                               
            tempTSI = tsi.readPercentage();        
            if (tempTSI > TSILIMIT){
                tsidata = tempTSI;
                if (fabs(tsidata - lastTouch)> PRINTDELTA){
                    pc.printf("Position %0.4f\n\r", tsidata);
                }           
            }
            lastTouch=tsidata;
        }// end if statement to read tsi
            } //end if statement for display state = 0
        //press left button - CALC MODE (green led)
        else if (displayState == 1){
            //turn on red led
            rled = 1.0;
            gled = 0.0;
            
            //multiply tsidata percentage by 100
            float data = tsidata*100;
            
            //initialize variables for calculation
            float xOld = 0.0;
            float xNew = 0.0;
            
            //calculate newton's method for square root
            xOld = float(data/2.5); //make first guess
            for (int x = 0; x< 20; x++){
                xNew =  0.5 * (xOld + data/xOld) ;
                float delta = fabs(xNew-xOld); //compare new and old values
                if (delta < 1e-7)
                    break;
                else
                    xOld = xNew; //replace calculated  value and retry
                }//end for loop

            //display data
            sprintf (lcdData,"%1.2f",xNew);  
           
        } //end displaystate 1
        
    
    LCDMess(lcdData); 
    } //end while true
}//end main