#include "mbed.h"
#include <math.h>  
#include "SLCD.h"

#define LEDON false
#define LEDOFF true
#define NUMBUTS 2
#define LBUT PTC12  // port addresses for buttons
#define RBUT PTC3

#define STOPPEDSTATE 0
#define TIMINGSTATE  1
#define RESETTINGSTATE 2

#define PRINTDELTA 0.01
#define LCDCHARLEN 10
#define BUTTONTIME 0.2
#define FULLMINUTE 60 //seconds
#define PROGNAME "kl46z_stop_watch_v1\n\r"
#define LCDTITLE "STPW"
#define TITLEWAIT 2.0

//#define PRINTDBUG // uncomment if printing to serial port desired

SLCD slcd; //define LCD display
Serial pc(USBTX, USBRX);

Timer ButtonTimer; // for reading button states
DigitalIn leftButton(LBUT);
DigitalIn rightButton(RBUT);
int displayState = STOPPEDSTATE;


void initialize_global_vars(){
    pc.printf(PROGNAME);
    // set up DAQ timer
    // set up DAQ timers
    ButtonTimer.start();
    ButtonTimer.reset(); 
} 

void LCDMess(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
}
void showTitle(){
    LCDMess(LCDTITLE);
    wait(TITLEWAIT);
    return;
}
int main(void) {
    char lcdData[LCDCHARLEN];
    PwmOut gled(LED_GREEN);
    PwmOut rled(LED_RED);
    pc.printf(PROGNAME);
    float secondsCount = 0.0;
    int minutesCount; // for displaying mininuts
    int seconds; //
    int fifthSeconds;
    bool statetoggle = false; //start timer in "stopped" state.
    
    initialize_global_vars();
    showTitle();

     while (true) {
        if (ButtonTimer > BUTTONTIME){
            //CKM: set up displayState via button pushes
            
            //both buttons: clear timer then go to stopped
            if (!leftButton && !rightButton){
                displayState = RESETTINGSTATE;
            }
            else if(!leftButton) { //left button: start timing
                    displayState = TIMINGSTATE;          
            }
            else if(!rightButton){ //right button: stop timing
                    displayState = STOPPEDSTATE;
            }//end if statement          
            
            ButtonTimer.reset();
            switch (displayState){
                    case STOPPEDSTATE : {    
                        if (statetoggle == true){   //if state is timing,
                            statetoggle = false;    //set it to stopped mode
                        }                 
                        rled = 0.0; //red led turns on
                        gled = 1.0;
                        break;
                    }
                    case RESETTINGSTATE:
                        secondsCount = 0;               //clear timer counter,
                        displayState = STOPPEDSTATE;    //THEN go to stopped
                        rled = 0.0; //red led turns on
                        gled = 0.0; //green led turns on
                        break;
                        
                    case TIMINGSTATE : {
                        if (statetoggle ==false){   //if state is in stopped mode,
                            statetoggle = true;     //start timing
                        }
                        secondsCount = secondsCount + BUTTONTIME; 
                                      
                        rled = 1.0;
                        gled = 0.0; //green led turns on
                        break;
                    }
            }
            
            // Parse the seconds
            seconds = (int)secondsCount; // make seconds "mask"
            fifthSeconds = (int)((secondsCount - (float)seconds) * 10); // the 0.2 seconds
            minutesCount = seconds / FULLMINUTE;
            seconds = seconds % FULLMINUTE;          
            sprintf (lcdData,"%1d.%02d.%1d",minutesCount,seconds,fifthSeconds);  
            LCDMess(lcdData);            
        }// end Button timer
    }//end while-true
}//end main