#include "mbed.h"
#include "SLCD.h"
#include "TSISensor.h"


#define PROGNAME "lightsense_kl46z_basic modified by CKM v1\n\r"
#define DATATIME 400 // milliseconds
#define LCDLEN 10
#define LIGHTSENSORPORT PTE22
#define TSILIMIT 0.99
#define TSIHALFPOINT 0.5 //used to determine halfpoint of slider

// port addresses for buttons
#define LBUTTON PTC12  
#define RBUTTON PTC3

//timer for button read
#define BUTTONTIME 0.2
//defined variable for number of buttons
#define NUMBUTS 2



SLCD slcd; //define LCD display globally define
Serial pc(USBTX, USBRX);
Timer LEDTimer;

//set up buttons and timer for reading states
DigitalIn leftButton(LBUTTON);
DigitalIn rightButton(RBUTTON);
Timer ButtonTimer;

//boolean to determine mode of reading.
// 0(false) = 16 bit mode.
// 1(true) = floating point mode.
bool displayMode;

void LCDMess(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
} 


int main() {
    //set up LEDs
    PwmOut gled(LED_GREEN);
    PwmOut rled(LED_RED);
    
    //create Analogin object with port PTE22
    AnalogIn LightSensor(LIGHTSENSORPORT);
    
    //create TSI (slider) object to read tsidata (put into a float below)
    TSISensor tsi;
    
    //start up button timer
    ButtonTimer.start();
    ButtonTimer.reset();
    
    float tsidata;
    float lightData; 
    float ledData;
    char lcdData[LCDLEN];
   
    int timeToChangeDF = DATATIME;
    LEDTimer.start();
    LEDTimer.reset();
    pc.printf(PROGNAME);
    
    while(true) {    
        if (LEDTimer.read_ms() > timeToChangeDF){ // check for timer time out transtion
            
            if(displayMode == 1){ //if in floating point mode, display floating point numbers
                lightData = (1.0 - LightSensor.read()); // show as increasiing with increasing intensity 
                sprintf(lcdData,"%4.3f",lightData); //print data to lcd screen 
            }
            else if (displayMode == 0){ //if in 16 bit mode, display 16 bit numbers
                lightData = LightSensor.read_u16();
                
                //SLIDER STUFF//
                //read slider data, put into float variable
                tsidata = tsi.readPercentage();
                
                if (tsidata < TSILIMIT){//if tsi data is read before the half point
                    if (tsidata < TSIHALFPOINT){ //show first 4 digits if slider reads left side
                        float divData = (int)lightData/10;
                        sprintf(lcdData, "%4.0f", divData);//dividing by ten to show first 4
                    }            
                    else if (tsidata > TSIHALFPOINT){ //if tsidata is read past half point
                        float modData = (int)lightData%10000;
                        sprintf(lcdData, "%4.0f", modData);//modulus by 10k to show last 4
                        
                    }//end inner if-elseif (tsidata < TSHIHALFPOINT)
                }//end outer if (tsidata <TSILIMIT)
            }//end outer if-elseif (displayMode)

            //set LEDs to light data value for brightness
            //they get brighter in dark rooms and dimmer in bright rooms
            //these values only use the floating point format since
            //ADC format can't be translated to the LEDs as easily.
            ledData = (1.0 - LightSensor.read());
            gled = ledData;
            rled = ledData;
            
            LCDMess(lcdData);  
            timeToChangeDF = DATATIME;
            LEDTimer.reset();
        }//end if  (LEDtimer)
        
        if (ButtonTimer > BUTTONTIME){
                if(!leftButton) { //on left button push, set mode to 0 (float)
                    displayMode = 0;            
                }
                if(!rightButton){ //on right button push, set mode to 1 (ADC)
                    displayMode = 1;
                }//end inner if statement (!leftButton)
            ButtonTimer.reset();
        }//end outer if statement (buttonTimer)
    }// end while (true)
}//end main