#include "mbed.h"
#include "TSISensor.h"
#include "SLCD.h"
#define TSILIMIT 0.99
#define LCDCHARLEN 10
#define DATAINTERVAL 0.1
#define PROGNAME "kl46z_slider_test_v1_modified\n\r"

SLCD slcd; //define LCD display
Serial pc(USBTX, USBRX);

Timer readTimer; //timer to use instead of wait function

float tsidata;

float oldtsidata = 0.0; //variable to hold data for comparison

void LCDMess(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
}

int main(void) {
    char lcdData[LCDCHARLEN];
    PwmOut gled(LED_GREEN);
    PwmOut rled(LED_RED);
    pc.printf(PROGNAME);
    TSISensor tsi;
    
    readTimer.start();
    readTimer.reset();

     while (true) {
        if (readTimer > DATAINTERVAL){ //use if statement instead of wait
            tsidata = tsi.readPercentage();
            if (tsidata > TSILIMIT){
                gled = 0.0;
                rled = 0.0;
            }else {
                //have the terminal show info only if the data has changed by 0.01.
                //would have perferred to use abs() function here but it did not
                //seem to support importing math libraries -CKM
                if ( (tsidata - oldtsidata) >= 0.01 || (oldtsidata - tsidata >= 0.01) ){
                    pc.printf("\n Position %f\n\r", tsidata);
                    }
                sprintf (lcdData,"%0.4f",tsidata);  
                LCDMess(lcdData);  
                gled = tsidata;
                rled = 1.0 - tsidata;
            }//end if-else statement
            
            oldtsidata = tsidata;
            
            readTimer.reset();
    }//end while loop
    
            //wait(DATAINTERVAL);
    }
}