#include "mbed.h"
#include "SLCD.h"

#define LEDON false
#define LEDOFF true
#define NUMBUTS 2
#define LBUT PTC12  // port addresses for buttons
#define RBUT PTC3

//CKM: changed blinktime variable to 'blinkONtime' and changed length to .5 seconds (500 ms)
//Then, added a new variable called 'blinkOFFtime', which is set to .2 seconds (200 ms).
#define BLINKONTIME 0.5 //500 ms
#define BLINKOFFTIME 0.2 //200 ms

#define BUTTONTIME 0.2
#define LCDCHARLEN 25 //CKM: changed character length to 25 for character array 
#define NUMMESS 2
#define LRED "RED"
#define LGREEN "GREN"
#define PRED "RED BUTTON PUSHED\r\n" //CKM: changed serial output #DEFINE to "RED BUTTON PUSHED"
#define PGREEN "GREEN BUTTON PUSHED\r\n" //CKM: changed serial output #DEFINE to "GREEN BUTTON PUSHED"
#define PROGNAME "blink_kl46z_buttton LCD v2\r\n"

// slightly more interesting blinky 140814 sc
SLCD slcd; //define LCD display

// Timer to elliminate wait() function
Timer LEDTimer; // for blinking LEDs
Timer ButtonTimer; // for reading button states

bool ledState = LEDON;

DigitalIn buttons[NUMBUTS] = {RBUT, LBUT};
DigitalOut LEDs[NUMBUTS] = {LED_GREEN, LED_RED};
Serial pc(USBTX, USBRX);// set up USB as communicationis to Host PC via USB connectons

void allLEDsOff(){
    int i;
    for (i=0; i<NUMBUTS; i++){ 
        LEDs[i] = LEDOFF;    
    }
}
 
void LCDMess(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
}

void initialize_global_vars(){
    pc.printf(PROGNAME);
    // set up DAQ timers
    ButtonTimer.start();
    ButtonTimer.reset();
    LEDTimer.start();
    LEDTimer.reset();  
    allLEDsOff();
} 
// --------------------------------
 int main() {
    int i; 
    int currentLED = 0;
    char rMess[NUMMESS][LCDCHARLEN]={LGREEN, LRED}; // for LCD
    char pMess[NUMMESS][LCDCHARLEN]={PRED, PGREEN}; // for pc serial port

    initialize_global_vars(); //keep things organized
    LEDs[currentLED] = LEDON;
    LCDMess(rMess[currentLED]);
    pc.printf(pMess[currentLED]);
// End of setup
    while(true) {
        if (ButtonTimer > BUTTONTIME){
            for (i=0; i<NUMBUTS; i++){ // index will be 0 or 1 
                if(!buttons[i]) { 
                    allLEDsOff();  
                    LCDMess(rMess[i]);
                    pc.printf(pMess[i]); 
                    currentLED = i;
                } // if ! buttons
            }// for loop to look at buttons
            ButtonTimer.reset();
        }
        if(LEDTimer.read() > BLINKONTIME && ledState){
            LEDTimer.reset();               
            ledState = !ledState; // Flip the general state
            LEDs[currentLED] = ledState;
        }
        //added an else if statement with regards to the state of the LED
        //and the new variable, 'blinkOFFtime'. This will reset the LED
        //according to the blinkOFFtime variable instead of the blinkONtime
        //variable if the ledState is false.
        else if (LEDTimer.read() > BLINKOFFTIME && !ledState)
        {
            LEDTimer.reset();               
            ledState = !ledState; // Flip the general state
            LEDs[currentLED] = ledState;
        }
    // Do other things here between times of reading and flashing
    }
}