#include "mbed.h"
#include <math.h>  
#include "TSISensor.h"
#include "SLCD.h"

#define NUMBUTS 2
#define LBUT PTC12  // port addresses for buttons
#define RBUT PTC3

#define ARGUMENTSTATE 0 //states to operate in
#define COUNTSTATE 1

#define TSILIMIT 0.01
#define LCDCHARLEN 10
#define DATAINTERVAL 0.1
#define BUTTONTIME 0.1
#define PROGNAME "kl46z_recursion_v1\n\r"

SLCD slcd; //define LCD display
Serial pc(USBTX, USBRX);

Timer dataTimer;
Timer ButtonTimer; // for reading button states
DigitalIn buttons[NUMBUTS] = {RBUT, LBUT};
float tsidata;
int displayState = 0; //start program in argument state
bool recursion = false;

void initialize_global_vars(){
    pc.printf(PROGNAME);
    // set up DAQ timers
    ButtonTimer.start();
    ButtonTimer.reset();
    dataTimer.start();
    dataTimer.reset(); 
} 

void LCDMess(char *lMess){
    slcd.Home();
    slcd.clear();
    slcd.printf(lMess);
}

void backward_count(float n,int delta,int min_num){
    pc.printf("\n Number: %2.0f\n\r", n);
    if (n <= min_num){
        recursion = false; //set flag to false to prevent repeats
        return;
    }
    else {
        backward_count(n-delta, delta, min_num);
    }
}

int main(void) {
    int i;
    char lcdData[LCDCHARLEN];
    TSISensor tsi;
    float tempTSI;
    PwmOut gled(LED_GREEN);
    PwmOut rled(LED_RED);
    
    initialize_global_vars();

     while (true) {
        if (ButtonTimer > BUTTONTIME){
            for (i=0; i<NUMBUTS; i++){ // index will be 0 or 1 
                if(!buttons[i]) { 
                    displayState = i; //set display state
                } // if ! buttons
            }// for loop to look at buttons  
            
        ButtonTimer.reset();
        }//end if buttonTimer

        //right button - ARGUMENT STATE(red led)
        //this state uses the slider to read a value, which
        //will be passed into a simple recursive function later
        if (displayState == ARGUMENTSTATE){
            
            //turn on red led
            rled = 0.0;
            gled = 1.0;
            
            //if statement to read tsi
            if(dataTimer.read() > DATAINTERVAL){
                dataTimer.reset();                               
                tempTSI = tsi.readPercentage();        
                if (tempTSI > TSILIMIT){
                    tsidata = (tempTSI*100)/2;      
                }
            }// end if statement to read tsi
        
            //send data to LCD
            //range 2-50
            sprintf (lcdData,"%2.0f", tsidata );  
            
            recursion = true;   //set bool to true so that the function can run
                                //in count mode
        } //end argument state
            
        //left button - COUNT STATE (green led)
        else if (displayState == COUNTSTATE){
            //turn on green led
            rled = 1.0;
            gled = 0.0;
            
            //code for recursion goes here
            //2nd and 3rd passed variables are hardcoded here
            //2nd variable: delta
            if (recursion == true){
                recursion = false; //set recursion bool to false to prevent
                                    //repeat function calls from here
                backward_count(tsidata, 2, -5);
           }
        } //end count state
    
    LCDMess(lcdData); 
    } //end while true
}//end main