#include "mbed.h"
#include "TFT_4DGL.h"
#include "MSCFileSystem.h"
#include "IniFile.h"

// Ini file value (int/bool/string)
// Key1 = 123            -> 123         (int)
// Key2 = 0x123          -> 291         (int)
// Key3 = FALSE          -> false       (bool)
// Key4 = TRUE           -> true        (bool)
// Key5 = 123            -> true        (bool)
// key6 =   abc "def     -> 'abc "def'  (string)
// key7 = " ghi "jkl "   -> ' ghi "jkl '(string)
// #comment line

//uLCD-32PT(SGC) 4d-systems display

TFT_4DGL display(p9,p10,p11); // serial tx, serial rx, reset pin;

Serial pc2(USBTX, USBRX); // tx, rx

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

DigitalIn adc_stop(p12);

AnalogIn Sense1(p15); //Sensor 1
AnalogIn Sense2(p16); //Sensor 2
AnalogIn Sense3(p17); //Sensor 3
AnalogIn Sense4(p18); //Sensor 4
AnalogIn Sense5(p19); //Sensor 5
AnalogIn Sense6(p20); //Sensor 6

Ticker t1; //Timer 1
Ticker t2; //Timer 2
Timer timer;

#ifndef MAX
#define MAX(a, b) (((a) > (b)) ? (a) : (b))
#endif

#ifndef MIN
#define MIN(a, b) (((a) < (b)) ? (a) : (b))
#endif

#ifndef ABS
#define ABS(a) (((a) < 0) ? -(a) : (a))
#endif

#define     ROOT_PATH    "/local/"
#define     ROOT_LEN    (sizeof(ROOT_PATH) - 1)

const char INI_FILE[] = ROOT_PATH "param.ini";

const char DEFAULT_ADC_FILENAME[]  = "data.csv";
const int  DEFAULT_SAMPLES         = 200;
const int  DEFAULT_SPEED           = 100;

const int  INI_BUF = 100;


// Function Declarations

void tint1( void );
void tint2( void );
void alarm( int val, int lim);
float convert( char *str);

float analog1( int val2);
float analog2( int val2);
float analog3( int val2);
float analog4( int val2);
float analog5( int val2);
float analog6( int val2);

float FloatingAverage1( float newval1);
float FloatingAverage2( float newval2);
float FloatingAverage3( float newval3);
float FloatingAverage4( float newval4);
float FloatingAverage5( float newval5);
float FloatingAverage6( float newval6);

int intflag1;
int intflag2;
int x = 0, y = 0, status, xc = 0, yc = 0;

int begin, end;
float adc_time = 0.1;



int main() {

    char s[100];
    unsigned int v1 = 0, v2 = 0, v3 = 0, v4 = 0, v5 = 0, v6 = 0;
    unsigned int Dcount = 0;

    float ComVal = 0.0;
    unsigned short usCurrentValue;

    float Voltage1;
    float Voltage2;
    float Voltage3;
    float Voltage4;
    float Voltage5;
    float Voltage6;

    pc2.baud(115200);

    int file_nr = 0;

    char clear[] = {27, '[', '2', 'J'};
    char home[] = {27, '[', '0', '0', 'H'};

    char   adc_filename[INI_BUF];
    int    adc_samples        = DEFAULT_SAMPLES;
    int    adc_speed_ms       = DEFAULT_SPEED;

    LocalFileSystem local("local");

    {
        pc2.printf("%s", clear);
        pc2.printf("%s", home);

        strcpy(adc_filename, DEFAULT_ADC_FILENAME);


        IniFile::getval(INI_FILE,    "FILENAME",    adc_filename, sizeof(adc_filename));
        IniFile::getval(INI_FILE,    "SAMPLES",        adc_samples);
        IniFile::getval(INI_FILE,    "SPEED",        adc_speed_ms);

        printf("\n\n");
        printf("FILENAME = %s\n", adc_filename);
        printf("SAMPLES  = %d\n", adc_samples);
        printf("SPEED    = %d\n", adc_speed_ms);

        wait(1);

        adc_time = (float) adc_speed_ms/1000.0;
        printf("\nadc_time = %.2f sec", adc_time);
    }

    display.baudrate(256000);
    
    
    //display.uSD_Image(0, 0, 0x000000);   //Display the mbed image - X-pos, Y-pos, Sector Address
    //wait(4.0);
    //display.cls();
    //display.uSD_Image(80, 240, 0x00E2);   //Display the mbed image - X-pos, Y-pos, Sector Address
    //wait(4.0);
    display.cls();
    
    
    display.background_color(LGREY);
    display.pen_size(WIREFRAME);
    display.text_mode(TRANSPARENT);

    display.text_string("ADC LOGGER ver 1.01", 3, 1, FONT_8X8, 0x000000);

    display.pen_size(SOLID);
    display.pen_size(WIREFRAME);
    display.rectangle(18, 132, 220, 301, 0x000000);
    display.pen_size(SOLID);
    display.rectangle(19, 133, 219, 300, 0xFFFFFF);
    display.text_string("SAMPLES : ", 3, 8, FONT_8X8, 0x000000);
    display.text_string("ADC1: ", 3, 10, FONT_8X8, BLACK);
    display.text_string("ADC2: ", 3, 11, FONT_8X8, BLUE);
    display.text_string("ADC3: ", 3, 12, FONT_8X8, RED);
    display.text_string("ADC4: ", 3, 13, FONT_8X8, DGREEN);
    display.text_string("ADC5: ", 3, 14, FONT_8X8, BROWN);
    display.text_string("ADC6: ", 3, 15, FONT_8X8, MAGENTA);

    t1.attach(&tint1,adc_time);
    t2.attach(&tint2,1.0);

    display.set_font(FONT_8X8);
    display.pen_size(SOLID);
    display.text_mode(OPAQUE);
    display.color( 0x000000);
    display.display_control(TOUCH_CTRL, ENABLE);
    display.set_touch(0, 0, 239, 319);

    pc2.printf("%s", clear);
    pc2.printf("%s", home);

    while (1) {

        MSCFileSystem msc("local"); // Mount flash drive under the name "local"

        {

            display.text_mode(TRANSPARENT);
            display.text_button("START", UP, 20, 30, 0x00FF00, FONT_12X16, BLACK, 1, 1);
            display.text_mode(OPAQUE);

            while (!((x > 20 && x < 88) && (y > 30 && y < 53))) {
                display.Pause_Until_Touch(&x, &y);
                pc2.printf("x=%i\n",x);
                pc2.printf("y=%i\n",y);
            }

            x = 0;
            y = 0;

            display.pen_size(SOLID);
            display.rectangle(20, 30, 88, 53, LGREY);

            Dcount = 19;
            file_nr = file_nr + 1;

            int i;
            char path[INI_BUF];
            sprintf(path, "/local/%i%s", file_nr, adc_filename);
            printf(path, "\n/local/%i%s", file_nr, adc_filename);
            printf("\n");
            FILE *fp = fopen(path, "w");  // Open "adc_filename.csv" on the local file system for writing

            display.rectangle(19, 133, 219, 300, 0xFFFFFF);

            ComVal = adc_samples;

            timer.start();
            begin = timer.read_us();


            for (i=0; i < ComVal ; i++) {

                led4 = 1;

                while (intflag1 == 0) {
                    wait_us(10);
                }
                intflag1 = 0;

                pc2.printf("i = %i\n", i+1) ;

                display.locate(13,8);
                sprintf(s, "%d     ",i+1);
                display.puts(s);

                display.locate(20,8);
                sprintf(s, "(%.0f)     ",ComVal);
                display.puts(s);

                Voltage1 = FloatingAverage1(analog1(usCurrentValue));
                Voltage2 = FloatingAverage2(analog2(usCurrentValue));
                Voltage3 = FloatingAverage3(analog3(usCurrentValue));
                Voltage4 = FloatingAverage4(analog4(usCurrentValue));
                Voltage5 = FloatingAverage5(analog5(usCurrentValue));
                Voltage6 = FloatingAverage6(analog6(usCurrentValue));

                if (Dcount >= 219) {
                    Dcount = 19;
                    display.rectangle(19, 133, 219, 300, 0xFFFFFF);
                }

                v1 = Voltage1 * 50;
                v1 = 299 - v1;
                display.pixel(Dcount, v1, BLACK);

                v2 = Voltage2 * 50;
                v2 = 299 - v2;
                display.pixel(Dcount, v2, BLUE);

                v3 = Voltage3 * 50;
                v3 = 299 - v3;
                display.pixel(Dcount, v3, RED);

                v4 = Voltage4 * 50;
                v4 = 299 - v4;
                display.pixel(Dcount, v4, DGREEN);

                v5 = Voltage5 * 50;
                v5 = 299 - v5;
                display.pixel(Dcount, v5, ORANGE);

                v6 = Voltage6 * 50;
                v6 = 299 - v6;
                display.pixel(Dcount, v6, MAGENTA);

                Dcount++;

                if (intflag2 == 1) {

                    display.locate(9,10);
                    sprintf(s, "%.3f volt ", MAX(Voltage1,0));
                    display.puts(s);

                    display.locate(9,11);
                    sprintf(s, "%.3f volt ", MAX(Voltage2,0));
                    display.puts(s);

                    display.locate(9,12);
                    sprintf(s, "%.3f volt ", MAX(Voltage3,0));
                    display.puts(s);

                    display.locate(9,13);
                    sprintf(s, "%.3f volt ", MAX(Voltage4,0));
                    display.puts(s);

                    display.locate(9,14);
                    sprintf(s, "%.1f deg c   ",Voltage5*100-273.12);
                    display.puts(s);

                    display.locate(9,15);
                    sprintf(s, "%.1f deg c   ",Voltage6*100-273.12);
                    display.puts(s);

                    intflag2 = 0;
                }

                fprintf(fp, "%d\t%.3f\t%.3f\t%.3f\t%.3f\t%.3f\t%.3f\r\n",(i+1) , Voltage1, Voltage2, Voltage3, Voltage4, Voltage5, Voltage6);

                if (!adc_stop) {
                    i = ComVal;
                }

            }

            end = timer.read_us();
            printf("Time = %d us\n", end - begin);
            fclose(fp);
            led4 = 0;

        }
    }

}

// Convert command
float convert( char *str) {
    float ComVal;
    ComVal = atoi(str+1);

    return ComVal;
}

// Interrupt for the Timer 1
void tint1( void ) {
    led2 = !led2;
    intflag1 = 1;
}

// Interrupt for the Timer 2
void tint2( void ) {
    led3 = !led3;
    intflag2 = 1;
}

// ADC1
float analog1( int val2) {
    float usCurrentValue = Sense1.read_u16()/16;
    return usCurrentValue*3.3/4095;
}
// ADC2
float analog2( int val2) {
    float usCurrentValue = Sense2.read_u16()/16;
    return usCurrentValue*3.3/4095;
}
// ADC3
float analog3( int val2) {
    float usCurrentValue = Sense3.read_u16()/16;
    return usCurrentValue*3.3/4095;
}
// ADC4
float analog4( int val2) {
    float usCurrentValue = Sense4.read_u16()/16;
    return usCurrentValue*3.3/4095;
}
// ADC5
float analog5( int val2) {
    float usCurrentValue = Sense5.read_u16()/16;
    return usCurrentValue*3.3/4095;
}
// ADC6
float analog6( int val2) {
    float usCurrentValue = Sense6.read_u16()/16;
    return usCurrentValue*3.3/4095;
}

// Floating Average routine 1
float FloatingAverage1(float newval1) {
    static float numbers[5];
    static float sum = 0;
    static int count = 0;
    int size;
    int i;

    size = sizeof(numbers)/sizeof(float);

    if (count < size) {
        count++;
    } else {
        sum -= numbers[0];
    }
    for (i = size - count ; i < size-1; i++) {
        numbers[i] = numbers[i+1];
    }
    sum += newval1;
    numbers[size-1] = newval1;

    return sum / (float)count;
}
// Floating Average routine 2
float FloatingAverage2(float newval2) {
    static float numbers[5];
    static float sum = 0;
    static int count = 0;
    int size;
    int i;

    size = sizeof(numbers)/sizeof(float);

    if (count < size) {
        count++;
    } else {
        sum -= numbers[0];
    }
    for (i = size - count ; i < size-1; i++) {
        numbers[i] = numbers[i+1];
    }
    sum += newval2;
    numbers[size-1] = newval2;

    return sum / (float)count;
}
// Floating Average routine 3
float FloatingAverage3(float newval3) {
    static float numbers[5];
    static float sum = 0;
    static int count = 0;
    int size;
    int i;

    size = sizeof(numbers)/sizeof(float);

    if (count < size) {
        count++;
    } else {
        sum -= numbers[0];
    }
    for (i = size - count ; i < size-1; i++) {
        numbers[i] = numbers[i+1];
    }
    sum += newval3;
    numbers[size-1] = newval3;

    return sum / (float)count;
}
// Floating Average routine 4
float FloatingAverage4(float newval4) {
    static float numbers[5];
    static float sum = 0;
    static int count = 0;
    int size;
    int i;

    size = sizeof(numbers)/sizeof(float);

    if (count < size) {
        count++;
    } else {
        sum -= numbers[0];
    }
    for (i = size - count ; i < size-1; i++) {
        numbers[i] = numbers[i+1];
    }
    sum += newval4;
    numbers[size-1] = newval4;

    return sum / (float)count;
}
// Floating Average routine 5
float FloatingAverage5(float newval5) {
    static float numbers[5];
    static float sum = 0;
    static int count = 0;
    int size;
    int i;

    size = sizeof(numbers)/sizeof(float);

    if (count < size) {
        count++;
    } else {
        sum -= numbers[0];
    }
    for (i = size - count ; i < size-1; i++) {
        numbers[i] = numbers[i+1];
    }
    sum += newval5;
    numbers[size-1] = newval5;

    return sum / (float)count;
}
// Floating Average routine 6
float FloatingAverage6(float newval6) {
    static float numbers[5];
    static float sum = 0;
    static int count = 0;
    int size;
    int i;

    size = sizeof(numbers)/sizeof(float);

    if (count < size) {
        count++;
    } else {
        sum -= numbers[0];
    }
    for (i = size - count ; i < size-1; i++) {
        numbers[i] = numbers[i+1];
    }
    sum += newval6;
    numbers[size-1] = newval6;

    return sum / (float)count;
}


