#include "mbed.h"
#include "HX711.h"
#include "TextLCD.h" 

DigitalOut led(LED1);
HX711 scale(PTC9, PTC8);

Serial rs232(USBTX, USBRX);    // USB Serial Terminal
//TextLCD lcd(PTE20,PTE21,PTE22,PTE23,PTE29,PTE30, TextLCD::LCD16x2); // Rs, E, d4, d5, d6, d7 

float calibration_factor = 1000; //Ajustar este valor para calibrar el peso exacto
int averageSamples = 100;

int main(void)
{
     
    scale.setScale(0);
    scale.tare(); //Reset the scale to 0
    
    long zero_factor = scale.averageValue(averageSamples); // Saca promedio de varias lecturas para estabilizar la medida
     
    while (true) {
        scale.setScale(calibration_factor); 
        float weight = scale.getGram();
        rs232.printf("Peso: %.2f\n", weight);
        //lcd.locate(0,0);
        //lcd.printf("Peso: %.2f Grms", weight);
        led = !led; // toggle led
        wait(0.2f);
    }
}