#ifndef Motor_H
#define Motor_H
#include "mbed.h"
 /* **************************************************************************
 
@CCastrop
cristiank.castrop@ecci.edu.co

    L1      Terminal A del motor
    L2      Terminal B del motor
    SpeedPin Pin de salida PWM
    
 LastVersion: 21 - Abril - 2019  7:45pm
******************************************************************************/


class MotorContinuo {
  public:
    /// Constructores para Motores Continuos
    MotorContinuo(PinName _L1, PinName _L2, PinName _speedPin, PinName _encodin, PinName _PosInicial, int _EncodPulses);
    
    void Forward();     // Da un sentido de giro al motor
    void Back();        // Genera un sentido de giro contrario al de Forward
    void Stop();        // Detiene el motor dejando el movimiento libre
    void StopT();       // Detiene el motor truncando o enclavando el movimiento(Lo mantiene quieto).
    void SpeedDuty(int v);   // Varia la velocidad de giro del motor de 0 a 100%
    void SpinLength_ms(float t);  // Duración del giro en ms
    void SpinLength(float t);  // Duración del giro
    
  private:

    DigitalOut L1;
    DigitalOut L2;
    PwmOut     speedPin;
    DigitalIn  encodin;
    DigitalIn  PosInicial;
    int EncodPulses;


    

};


class MotorDiscreto {
  public:
    /// Constructores para Motores Continuos
    MotorDiscreto(PinName _Dir, PinName _Step, int _NPasos, PinName _encodin, PinName _PosInicial, int _EncodPulses);
      
    MotorDiscreto(void);    
    
    void Forward();                 // Da un sentido de giro al motor
    void Back();                    // Genera un sentido de giro contrario al de Forward
    void Stop();                    // Detiene el motor dejando el movimiento libre. Pin Enable = 0
    void StopT();                   // Detiene el motor truncando o enclavando el movimiento(Lo mantiene quieto).
    void StepFreq(long n);           // Configura la Velocidad en Número(n) de pasos por segundos. Es decir la Frecuencia de paso.
    void RunStep(long n);           // Se mueve el motor la cantidad de pasos ingresada
    void Run(float t);              // Gira el motor durante el tiempo ingresado, si es 0 indefinidamente hasta llamada a Stop().
    void RunRound(int n);           // Girar n vueltas
    void Ustep(int resolucion, PinName M0, PinName M1, PinName M2);
                                    // Configura los pasos a 1/2, 1/4, 1/8, 1/16, 1/32
    long getStepOnHold(void);
                                    
    long StepOnHold;                // Pasos faltantes por ejecutar
    long StepsBySecond;             // Pasos por segundo
    
  private:
    
    void moveMotor(void);
    
    DigitalOut Dir;
    DigitalOut Step;
    int        NPasos;
    DigitalIn  encodin;
    DigitalIn  PosInicial;
    int        EncodPulses;
    
    DigitalOut* EnablePin;
    DigitalOut* M0;
    DigitalOut* M1;
    DigitalOut* M2;
    
    Ticker Move;                /// Timer de interrupcion
    float TStep;                /// periodo del paso TStep = 1/StepsBySecond;
    
    int entradas;               /// registra cada 2 ingresos a la interrupcion
    bool _moveMotorStopped;     // en 1 cuando se da la orden al motor de detenerse
};




class TraccionD
{
    
    public:
    
    TraccionD(PinName _StepMI, PinName _DirMI, PinName _StepMD, PinName _DirMD, int _NPasos, float _r, float _L); // para giro declarar primero la frecuencia de paso
    
    void Forward();                 // Da un sentido de giro al motor
    void Back();                    // Genera un sentido de giro contrario al de Forward
    void Left();                    // Configura el sentido de giro de ambos motores de manera contraria para girar hacia la izquierda
    void Right();                   // Configura el sentido de giro de ambos motores de manera contraria e inverso al de Left() para girar hacia la derecha
    void Stop();                    // Detiene el motor dejando el movimiento libre. Pin Enable = 0
    void StopT();                   // Detiene el motor truncando o enclavando el movimiento(Lo mantiene quieto).
    void StepFreq(long n);//maximo~350 // Configura la Velocidad en Número(n) de pasos por segundos. Es decir la Frecuencia de paso.
    void RunStep(long n);           // Se mueve el motor la cantidad de pasos ingresada
    void Run(float t);              // Gira el motor durante el tiempo ingresado, si es 0 indefinidamente hasta llamada a Stop().
    void RunRound(int n);           // Girar n vueltas
    void Giro(long grados, bool sentido);      // IMPORTANTE: Para llamar esta funcino PRIMERO se debe definir la frecuencia de paso
                                               // Gira el movil la cantidad de grados indicados en sentido indicado. 
                                               // en función del radio de las llantas y el radio del eje que une las llantas.
                                               // ejemplo: (90, Horario) o (120, AntiHorario)

    long getStepOnHold(void);
    
    
    private:
    
    void moveMotor(void);           // Funcion que es ejecutada cada interupcion del Ticker Move
    
                                    // Configuracion de los pines
    DigitalOut StepMI,DirMI;        
    DigitalOut StepMD, DirMD;
    int        NPasos;
    float r;                        // Radio de la llanta
    float L;                        // Longitud desde del eje medido entre las 2 llantas dividido en 2.
    float Rl;                       // Relacion(Rl) de distacia entre los dos Radios(r y L)
    long StepOnHold;                // Pasos faltantes por ejecutar
    long StepsBySecond;             // Pasos por segundo
    
    DigitalOut* EnablePinM1;
    DigitalOut* EnablePinM2;
    
    Ticker Move;                /// Timer de interrupcion
    float TStep;                /// periodo del paso TStep = 1/StepsBySecond;
    
    int entradas;               /// registra cada 2 ingresos a la interrupcion
                                    
    



};
#endif















