#include "mbed.h"
#include "scolor_TCS3200.h"


//******************************************************************************
//                          Definiciones

/// Puerto Serial
Serial SerialPort(SERIAL_TX, SERIAL_RX, 9600);

/// PWM OUTPUTS
PwmOut Buzzer(LED1);

//  Temporizadores 
Ticker LengthTonoBuzzer;

// SENSOR DE COLOR
scolor_TCS3200 SENSOR_COLOR (PA_8, PB_10, PB_4, PB_5, PB_3); 


// constantes
//const int long_vector = 10; // longitud del vector

/// Global Variables



long red;
long blue;
long green;
long clear;

float F_red;
float F_blue;
float F_green;
float F_clear;

uint8_t coolterm_comand, i = 0;                      // Variable usada como Indice de los vectores,
                                    // indica la posicion del vector en donde se reciben 
                                    // ó se almacenan los datos

float periodo_Buzzer = 1;           
uint8_t duracion_Tono = 1;

#define DO 3.78 /// VALOR DEL PERIODO EN MS
#define RE 3.36 /// VALOR DEL PERIODO EN MS
#define MI 3.03 /// VALOR DEL PERIODO EN MS
#define SI 2.02 /// VALOR DEL PERIODO EN MS

  

//******************************************************************************
// COMANDOS

#define iniciar_telemetria 0xFE
#define CMD_rojo   0x01
#define CMD_azul   0x02
#define CMD_verde  0x03
#define CMD_clear  0x04
#define ColorNoIdentificado 0x05

uint8_t color_identificado = ColorNoIdentificado;

//****************************************************************************
// prototipo de funciones

void ReadPort(void);                // Lee el puerto Serial
void MainConfig(void);              // Configuracion Inicial de los Perifericos del uC
void leer_color(void);              // funcion que retorna los componentes
                                    // RGB y Clear del color leido
//****************************************************************************
//

void ReadPort()
{
    
    coolterm_comand = SerialPort.getc();
    
}
 

int main()
 {
    Buzzer.write(0);
    SerialPort.attach(&ReadPort, Serial::RxIrq);
    SerialPort.printf("Hello World, System Run !!\n");
    
    while(1)
    {
        
        while (coolterm_comand != iniciar_telemetria);
        SerialPort.printf("COMANDO RECIBIDO!!\n");
        
        leer_color();
        coolterm_comand = 0;
        
              
        /*
        switch(coolterm_comand)
        {
            case CMD_rojo:  leer_color();  
                    break;    
            
            case CMD_azul:  leer_color();
                    break;    
            
            case CMD_verde:  leer_color();
                    break;    
            
            case CMD_clear:  leer_color();
                    break;    
            default :       
                    break;    
            
          
            
        }*/  
    
    
    
    }
    
    
}


void leer_color()
    {
    
        red    = SENSOR_COLOR.ReadRed(); // OBTENEMOS EL TIEMPO DEL CICLO UTIL DE LA FRECUENCIA DE SALIDA 
        green  = SENSOR_COLOR.ReadGreen();
        blue   = SENSOR_COLOR.ReadBlue();
        clear  = SENSOR_COLOR.ReadClear();
        
        //printf("RED: %5d     GREEN: %5d     BLUE: %5d     CLEAR: %5d    \n ", red, green, blue, clear);
         
        red     *= 2;   // Calculamos EL PERIODO de la frecuencia generada por la lectura del fotodiodo rojo         
        blue    *= 2;   // Calculamos EL PERIODO de la frecuencia generada por la lectura del fotodiodo rojo
        green   *= 2;   // Calculamos EL PERIODO  de la frecuencia generada por la lectura del fotodiodo rojo
        clear   *= 2;   // Calculamos EL PERIODO  de la frecuencia generada por la lectura del fotodiodo rojo
        
        //printf("RED: %5d     GREEN: %5d     BLUE: %5d     CLEAR: %5d    \n ", red, green, blue, clear);
         
        F_red     = (1 / ((float)red)) * (1000); /// calculando la FRECUENCIA de salida generada por el fotodiodo rojo
        F_blue    = (1 / ((float)blue)) * (1000);   /// calculando la FRECUENCIA de salida generada por el fotodiodo blue
        F_green   = (1 / ((float)green)) * (1000);  /// calculando la FRECUENCIA de salida generada por el fotodiodo green
        F_clear   = (1 / ((float)clear)) * (1000);  /// calculando la FRECUENCIA de salida generada por el fotodiodo clear
        
        
     
        //printf("RED: %5f     GREEN: %5f     BLUE: %5f     CLEAR: %5f    \n ", F_red, F_green, F_blue, F_clear);
        
        
        
       //////////////////////////////////////////////////////////////     
       ////         identificar azul
       
       
       if(red <=42 && red >=24)
        {
            if(green >= 20 && green <= 28 )
            {
                if(blue >= 10 && blue <= 16)
                {
                        color_identificado = CMD_azul;
                        printf ( "0x0%1x\n ", CMD_azul); 
                        Buzzer.period_ms(DO);
                        Buzzer.write(0.5);
                        wait(4);
                        Buzzer.write(0);
                       
                }
            }
         }   
                 
        
        
        
        /////////////////////////////////////////////////////////////
        ///         identificar rojo
        if(red <= 12 )
        {
            if(green >= 10 && green <= 28 ) 
                {
                    if(blue >= 18 && blue <= 24)
                    {
                            color_identificado = CMD_rojo;
                            printf ( "0x0%1x\n ", CMD_rojo ); 
                            Buzzer.period_ms(RE);
                            Buzzer.write(0.5);  //PERIODO UTIL
                            wait(4);            //TIEMPO ACTIVO DEL BUZZER
                            Buzzer.write(0.0);
                    }
                }
                
            if(green < 10 && green >= 6 )
                {
                    if(blue <= 12  )
                    {
                            color_identificado = CMD_clear;
                            printf ( "0x0%1x \n ", CMD_clear );
                            Buzzer.period_ms(MI);
                            Buzzer.write(0.5);
                            wait(4);
                            Buzzer.write(0);
                    }
                    
                }
            
         }   
         
         
       //////////////////////////////////////////////////////////////     
       ////         identificar cafe
       

           // if(red >=14 && red <= 18 )
            //    printf ( "0x0 %1x \n ", CMD_verde );

         
       //////////////////////////////////////////////////////////////     
       ////         identificar verde
       
             if(green >= 36 && green <= 44 )
            {
                if(red >= 40 && red <= 50 )
            
                {
                        color_identificado = CMD_verde;
                        printf ( "0x0%1x \n ", CMD_verde );
                            Buzzer.period_ms(SI);
                            Buzzer.write(0.5);
                            wait(4);
                            Buzzer.write(0); 
                        
                    
                }
            } 
            
            if  (color_identificado == ColorNoIdentificado)
            {
                
                 
                        printf ( "0x0%1x \n ", ColorNoIdentificado);
                            Buzzer.period_ms(10);
                            Buzzer.write(0.5);
                            wait(4);
                            Buzzer.write(0); 
                        
                
            }
                
            color_identificado = ColorNoIdentificado;
        }
        
        

