#include "mbed.h"
#include "Motor.h"
#include "TFTLCD.h"

//******* puerto serie *********//
Serial Mbed(PB_6, PB_7);

//******* Entrada de Interrupcion ENpulsosterna (pulso desde el encoder )*********//
InterruptIn Encoder(PC_9);

//******* Led depuración  *********//
DigitalOut LED(PD_9);

//******* Button para depuración  *********//
DigitalIn  Button(PA_0);

//******* Creacion del objeto de la Clase Motor  *********//
MotorContinuo MotorDC(PD_13, PD_11, PB_15, NC,NC,0);

Ticker Time;
//******* Declaración de Constantes y variables *********//

#define NPulsesEncoder 12
#define Nvel         9               /// Cantidad de Velocidades o variaciones del escalon
float EndTime = 12.0;                /// Tiempo total en el que se realizara todo el muestreo y se ejecutaran
                                     /// Las distintas variaciones del impulso (velocidades)
#define NSamples    600              /// Numero de muestras a tomar.
#define PulseTime    float(EndTime / Nvel)  /// Tiempo que dura cada pulso o variacion de velocidad

long  Npulsos = 0;                   /// Almacena la cantidad de pulsos generada por el sensor de herradura en el encoder

int   muestras[NSamples];            /// vector en donde se almacenan las 200 muestras de tipo long
float RPM[NSamples];                 /// Vector que almacena la convercion de pulsos a RPM del motor
float FactorConvercion;
float Ts;                            /// Sample Time 
float   PVel[Nvel] = {5.0, 25.3, 82.5, 56.5, 100, 10.0, 75.7, 30.2, 5}; /// Porcentaje de velocidad: esta es la variable independiente de control. 
                                     /// Es nuestra señal de entrada.
                                     /// Estos son los valores en porcentaje dentro del rango de 0 a 100, la cual indica el DUTY_CICLE de la
                                     /// Señal cuadrada que gobierna el movimiento del motor.

int NextSample = 0;                  /// Indice que se Desplaza a la siguiente Muestra


//******* Declaración de funciones  *********//


void config();
void Encoder_Int();
void Sample_Int();


//******* Definicion de funciones *********//

                
void Encoder_Int()        /// Interrupcioin Externa del sensor de Herradura sobre el encoder
{
    Npulsos ++;
}


void Sample_Int()
{
    // Mientras no excedamos el numero de muestras almacenamos Npulsos tomados en 
    // la posicion NextSample del vector muestras
    if (NextSample < NSamples) muestras[NextSample++] = Npulsos;
    Npulsos = 0;
            
}


void config()
{
   // start program messsage 
    Mbed.printf("Lets Work!!...\n");
    
   // Set External Interruption to rise flank
    Encoder.rise(&Encoder_Int);
   
    
   // Set a Motor movement direction
    MotorDC.Forward();

   // Sample Time
    int TotalSamples = NSamples;
    Ts = float(EndTime / TotalSamples); 
    Mbed.printf("Sample Time : %.3f!!...\n!", Ts);
    
    // Pulse Time
    Mbed.printf("Pulse Time : %.3f!!...\n!", PulseTime);
    
    // FactorConvercion = 60 segundos / Tiempo de muestreo * Numero de pulsos del encoder por vuelta
    FactorConvercion = float (60/(Ts * NPulsesEncoder));
    Mbed.printf("FactorConvercion : %.3f!!...\n!", FactorConvercion);
}



int main() {
    
    
    
    config();
   while (1)
   {
     
    while(Button == 1)   /// No ejecuta el código hasta presionar el boton
    {
       
        for(int v = 0 ; v < Nvel ; v++ )
        {
            // Set Speed of Motor modifying PWM Duty Cicle
            MotorDC.SpeedDuty(PVel[v]);
            // Set Time Interrupt each Ts seconds and callback Sample_Int() function.
            if (v == 0) Time.attach(&Sample_Int, Ts);
            
            
            Mbed.printf("Motor Velocidad = %0.2f%% : " , PVel[v]);
            LED = 1;
            // We wait duration Pulse Time
            wait(PulseTime); 
        
        }
      
            Time.detach();
            MotorDC.SpeedDuty(0);
            LED = 0;
            for(NextSample = 0; NextSample < NSamples; NextSample++ )
                {   
                    RPM[NextSample] = (muestras[NextSample] * FactorConvercion); 
                    Mbed.printf("Muestra %d : %d Pulses  %0.3f RPM \n", NextSample, muestras[NextSample], RPM[NextSample]); wait_ms(10);
                    
                }
        
        
      }
        
       // Mbed.printf("End of Work!!...\n!");
        
        
        
    }
}
