#include "mbed.h"
#include "Motor.h"
#define get_values
//******* puerto serie *********//
Serial Mbed(PB_6, PB_7);

//******* Entrada de Interrupcion ENpulsosterna (pulso desde el encoder )*********//
InterruptIn Encoder(PC_9);

//******* Analog IN  *********//


//******* Led depuración  *********//
DigitalOut LED(PD_9);

//******* Button para depuración  *********//
DigitalIn  Button(PA_0);

//******* Creacion del objeto de la Clase Motor  *********//
MotorContinuo MotorDC(PD_13, PD_11, PB_15, NC,NC,0);

Timeout Time;
//******* Declaración de Constantes y variables *********//

#define NPulsesEncoder 12
#define Nvel         1              /// Cantidad de Velocidades o variaciones del escalon
float EndTime = 0.83;              /// Tiempo total en el que se realizara todo el muestreo y se ejecutaran
                                     /// Las distintas variaciones del impulso (velocidades)
#define NSamples    830           /// Numero de muestras a tomar.
#define PulseTime    float(EndTime / Nvel)  /// Tiempo que dura cada pulso o variacion de velocidad

long  Npulsos = 0;                   /// Almacena la cantidad de pulsos generada por el sensor de herradura en el encoder
int   PVelocidadAplicada[NSamples];  /// Almaena Las velocidades que se aplicaron en cada muestra
int   muestras[NSamples];            /// vector en donde se almacenan las 200 muestras de tipo long
float RPM[NSamples];                 /// Vector que almacena la convercion de pulsos a RPM del motor
float RPS[NSamples];                 /// Vector que almacena la convercion de pulsos a RPM del motor
float FactorConvercion;              /// Almacena el factor de conversion de numero de pulsos a RPM
float Ts;                            /// Sample Time 
int   PVel[Nvel] = {100};//, 25, 50, 75, 100, 85, 60, 30, 10, 5}; /// Porcentaje de velocidad: esta es la variable independiente de control. 
                                     /// Es nuestra señal de entrada. puede ser float
                                     /// Estos son los valores en porcentaje dentro del rango de 0 a 100, la cual indica el DUTY_CICLE de la
                                     /// Señal cuadrada que gobierna el movimiento del motor.
int velActual;                       /// Almacena de manera temporal la velcidad que se esta aplicando.
int NextSample = 0;                  /// Indice que se Desplaza a la siguiente Muestra
int v;                               /// Indice que desplaza la Velocidad en PVel[]

//******* Declaración de funciones  *********//


void config();
void Encoder_Int();
void Sample_Int();


//******* Definicion de funciones *********//

                
void Encoder_Int()        /// Interrupcioin Externa del sensor de Herradura sobre el encoder
{
    Npulsos ++;
}


void Sample_Int()
{
    // Mientras no excedamos el numero de muestras almacenamos Npulsos tomados en 
    // la posicion NextSample del vector muestras
    if (NextSample < NSamples)
    {
         muestras[NextSample] = Npulsos;
         PVelocidadAplicada[NextSample++] = PVel[v];
         }
    Npulsos = 0;
    Time.attach(&Sample_Int, Ts);   
}


void config()
{
   // start program messsage 
    Mbed.printf("Lets Work!!...\n");
    
   // Set External Interruption to rise flank
    Encoder.fall(&Encoder_Int);
   
    
   // Set a Motor movement direction
    MotorDC.Forward();
    
    #ifdef depuration
   // Sample Time
    int TotalSamples = NSamples;
    Ts = float(EndTime / TotalSamples); 
    Mbed.printf("Sample Time : %.3f!!...\n!", Ts);
    
    // Pulse Time
    Mbed.printf("Pulse Time : %.3f!!...\n!", PulseTime);
    
    // FactorConvercion = 60 segundos / Tiempo de muestreo * Numero de pulsos del encoder por vuelta
    FactorConvercion = float (60/(Ts * NPulsesEncoder));
    Mbed.printf("FactorConvercion : %.3f!!...\n!", FactorConvercion);
    #endif
    
    #ifdef get_values
    
   // Sample Time
    int TotalSamples = NSamples;
    Ts = float(EndTime / TotalSamples); 
    // FactorConvercion = 60 segundos / Tiempo de muestreo * Numero de pulsos del encoder por vuelta
    FactorConvercion = float (60/(Ts * NPulsesEncoder));
    
    Mbed.printf("\t\tCurva Caracteristica del Motor \n\n Modelo del Motor : 40ZYN06 MaxVoltage Supply : 24V  Current : 1.5A   MaxRPM : 3700\n"); 
    Mbed.printf("\n\tTest Description\n\n Test Voltage Supply: 19.43V   Test Current Supply: 1.5A   \nEncoder Pulses : %d   # de Velocidades Aplicadas: %d ", NPulsesEncoder, Nvel);
    Mbed.printf("\nTotal Test Time: %.0fs   Samples: %d  Sample Time : %0.3fs   Duracion de Cada Velocidad: %.2fs Factor de Conversion(Pulses To RPM): %0.2f \n\n", EndTime, NSamples, Ts, PulseTime, FactorConvercion);
    Mbed.printf("\nPorcentaje de WeidthPulse Aplicadas durante el test(ordenado) :\n\t");
    for(int n = 0; n < Nvel; n++)Mbed.printf("\t%d%%,",PVel[n]);
    Mbed.printf("\n\t11 Mayo 2019 - Elaborado por Cristian Kevin Castro Parra\n");
    
    #endif
            
}



int main() {
    
    
    
    config();
   while (1)
   {
     
    while(Button == 1)   /// No ejecuta el código hasta presionar el boton
    {
       
        for(v = 0 ; v < Nvel ; v++ )
        {
            // Set Speed of Motor modifying PWM Duty Cicle
            MotorDC.SpeedDuty(PVel[v]);
            // Set Time Interrupt each Ts seconds and callback Sample_Int() function.
            if (v == 0) Time.attach(&Sample_Int, Ts);
            
            
            Mbed.printf("\nMotor Velocidad = %d%% : " , PVel[v]);

            // We wait duration Pulse Time
            wait(PulseTime); 
        
        }
      
            Time.detach();
            MotorDC.SpeedDuty(0);
            LED = 0;
            
            #ifdef depuration
            
            for(NextSample = 0; NextSample < NSamples; NextSample++ )
                {   
                    RPM[NextSample] = (muestras[NextSample] * FactorConvercion); 
                    Mbed.printf("Muestra %d : %d Pulses  %0.3f RPM \n", NextSample, muestras[NextSample], RPM[NextSample]); wait_ms(10);
                    
                }
            #endif
            
            #ifdef get_values
            Mbed.printf("\n\nVelocidad\tPulsos\tRPS\tRPM    Obtenidos durante el Test: \n");
            for(NextSample = 0; NextSample < NSamples; NextSample++ )
                {   
                    RPM[NextSample] = (muestras[NextSample] * FactorConvercion); 
                    RPS[NextSample] = (muestras[NextSample]/ float(NPulsesEncoder * Ts)); 
                }
                
            for(NextSample = 0; NextSample < NSamples; NextSample++ )
                {   
                    Mbed.printf("%d, %d, %.3f, %0.3f\n",PVelocidadAplicada[NextSample], muestras[NextSample], RPS[NextSample], RPM[NextSample]); wait_ms(5);
                    
                }
           /* 
           
            Mbed.printf("\nRPM Obtenidos durante el Test: \n");
            for(NextSample = 0; NextSample < NSamples; NextSample++ )
                {   
                    RPM[NextSample] = (muestras[NextSample] * FactorConvercion); 
                    Mbed.printf("%0.0f\n",RPM[NextSample]); wait_ms(1);
                    
                }
             */   
            #endif
            
        
      }
        
       // Mbed.printf("End of Work!!...\n!");
        
        
        
    }
}
