#ifndef Motor_H
#define Motor_H
#include "mbed.h"
 /* **************************************************************************
 
@CCastrop
cristiank.castrop@ecci.edu.co


   datasheet https://www.mouser.com/catalog/specsheets/TCS3200-E11.pdf


    S0      Frequency scaling 
    S1      Frequency scaling 
    S2      Photo diode selection 
    S3      Photo diode selection 
    OutFreq Frequency

       -----------------------------------
      |   ____________     ____________   |
----> |  |            |   |            |  |                ___     ___ 
Light |  | Photodiode |   |   Current  |--|---OUTPUT_FREQ |   |___|   |___
----> |  |   Array    |---|     to     |  |
      |  |            |   |  Frequency |  |
      |  |____________|   |____________|  |
      |       ^  ^             ^  ^       |
       -------|--|-------------|--|-------
              |  |             |  |
             S2 S3            S0  S1
             
SO | S1 | OUTPUT FREQUENCY SCALING |        | S2 | S3 |   PHOTODIODE TYPE   |
 0 | 0  |        power down        |        |  0 | 0  |         Red         |
 0 | 1  |           2%             |        |  0 | 1  |         Blue        |
 1 | 0  |           20%            |        |  1 | 0  |  Clear (no filter)  |
 1 | 1  |           100%           |        |  1 | 1  |         Green       | 
             
******************************************************************************/



class MotorContinuo {
  public:
  
    MotorContinuo(PinName L1, PinName L2, PinName speedPin); // declaracion del Objeto
    
    void Forward();     // Da un sentido de giro al motor
    void Back();        // Genera un sentido de giro contrario al de Forward
    void Stop();        // Detiene el motor dejando el movimiento libre
    void StopT();       // Detiene el motor truncando o enclavando el movimiento(Lo mantiene quieto).
    void SpeedDuty(int v);   // Varia la velocidad de giro del motor de 0 a 100%
    void SpinLength_ms(float t);  // Duración del giro en ms
    void SpinLength(float t);  // Duración del giro
    
    float GetSpeed();   // Return Duty Cycle of PWM in % de 0 a 100
    
  private:
    DigitalOut _L1;
    DigitalOut _L2;
    PwmOut _speedPin;
    

};
#endif















