#include "mbed.h"
#include "Motor.h"


MotorContinuo::MotorContinuo(PinName L1, PinName L2, PinName speedPin) : 
_L1(L1), _L2(L2), _speedPin(speedPin)
{
    _speedPin.period_ms(5);
    _speedPin.write(0);
};
 

void MotorContinuo::Forward()   { _L1=1;  _L2=0;}
void MotorContinuo::Back()      { _L1=0;  _L2=1;}
void MotorContinuo::Stop()      { _L1=0;  _L2=0;}
void MotorContinuo::StopT()     { _L1=1;  _L2=1;}
void MotorContinuo::SpeedDuty(int v) { _speedPin.write(float(v/100.0));}
void SpinLength_ms(float t)    { t++;}// Duración del giro en ms
void SpinLength(float t)       { t++;}
    
 /*   
void scolor_TCS3200::SetMode(uint8_t mode) {
    switch (mode){
        case SCALE_100:  _s0= 1; _s1=1; break;
        case SCALE_20:   _s0=1 ; _s1=0; break;
        case SCALE_2:    _s0=0 ; _s1=1; break;
        case POWER_DOWN: _s0=0 ; _s1=0; break;
    } 
};
 
 
long  scolor_TCS3200::pulsewidth() {
    while(!_s_in);
    timer.start();
    while(_s_in);
    timer.stop();
    float pulsewidth_v = timer.read_us();
    timer.reset();
    return pulsewidth_v;
};
*/          

