#include "mbed.h"




//******************************************************************************
//                          Definiciones

/// Puerto Serial
Serial SerialPort(SERIAL_TX, SERIAL_RX, 9600);

/// PWM OUTPUTS
PwmOut Buzzer(LED1);

//  Temporizadores 
Ticker LengthTonoBuzzer;

// constantes
const int long_vector = 10; // longitud del vector

/// Global Variables

uint8_t VCOMANDS     [long_vector]; // vector en donde se almacena la informacion 
                                    // Recividos por el PC (Los Comandos)
uint8_t VINDICATORS  [long_vector]; // vector en donde se almacena la informacion 
                                    // que se Enviara al PC (Los indicadores)

uint8_t i = 0;                      // Variable usada como Indice de los vectores,
                                    // indica la posicion del vector en donde se reciben 
                                    // ó se almacenan los datos

float periodo_Buzzer = 1;           
uint8_t duracion_Tono = 1;

//******************************************************************************

//                  Prototipo de Funciones

void ReadPort(void);                // Lee el puerto Serial
void MainConfig(void);              // Configuracion Inicial de los Perifericos del uC


void stopBuzzer(void);              // Detiene el Sonido del Buzzer
void BuzzerSound(void);             // Genera la Frecuencia de Audio en el Buzzer

//******************************************************************************

///             Configuración Inicial

void MainConfig(void)
    {
        
    // se habilita la interrupción RX
        SerialPort.attach(&ReadPort, Serial::RxIrq );
          
        
    // configuracion inicial del PWM Buzzer
        Buzzer.period(periodo_Buzzer);
        Buzzer.write(0.50);
    
    
    
    }



///             Función Principal

int main()
{
    
    MainConfig();
    // Mensaje Inicial
    SerialPort.printf("Hello World, System Run !!\n");
    
    
    
    
    while(1)
     {

            if(VCOMANDS[2] != 0)            // Si hemos enviado el comando de Ejecucion de Tono
                {
                    BuzzerSound();          // Genera el Tono Seleccionado   
                }
                
            /// Visualizamos la informacion que hemos Modificado
            SerialPort.printf("VCOMANDS[%d] = %d  - VCOMANDS[9] = %d\n", i, VCOMANDS[i], VCOMANDS[9]);
            wait(1); 
            
            
    }


}

//******************************************************************************

//                  Funciones Secundarias


void stopBuzzer(void)                               // Detiene el Tono del Buzzer, poniendo el ancho de pulso a 0;
{
    Buzzer.period(1); Buzzer.write(0);              // Volvemos a la configuracion Inicial del Buzzer       
    LengthTonoBuzzer.attach(&stopBuzzer,10000);     // Mientras no se envie un nuevo comando de tiempo para
                                                    // La interrupcion se deja un tiempo muy alto para generar la interrupcion
                                                    // Lo menos Posible
}

void BuzzerSound(void)
    {
        
    // Se calcula el valor del Periodo para el Buzzer limitando el ancho de banda de las
        // Frecuencias de entradas entre 1 y 20Hz ó 1 y 20KHz
        
        // hallamos el valor de 1 a 20 que se ha ingresado    
        if(VCOMANDS[1] <= 40) periodo_Buzzer = 1.0;           // Se restringe el limite inferior del valor ingresado a 40 y lo hace equivalente a un periodo de 1 segundo.
                    else if (VCOMANDS[1] > 60) periodo_Buzzer = 20.0;     // Se restringe el limite Superior del valor ingresado a 60 y lo hace equivalente a un periodo de 20 segundo.
                    else periodo_Buzzer = (float)(VCOMANDS[1] - 40);
                    periodo_Buzzer = (1 / periodo_Buzzer); //Se realiza la conversión de Frequencia a Periodo

                        
                    // Ahora si VCOMANDS[2] == 48 == '0'; la frecuencia estará en el orden de los Herz    
                    if (VCOMANDS[2] == 48) 
                        {
                            Buzzer.period(periodo_Buzzer);
                            VCOMANDS[2] = 0 ;
                        } 
                    // Pero si VCOMANDS[2] == 49 == '1'; la frecuencia estará en el orden de los KiloHerz
                    else if (VCOMANDS[2] == 49) 
                        {
                            Buzzer.period_us( (uint8_t)(periodo_Buzzer * 1000) );
                            VCOMANDS[2] = 0 ;
                        }
                    // Determinamos el tiempo por el cual estará sonando el Buzeer
                    if(VCOMANDS[0] <= 40) duracion_Tono = 1;           // Se restringe el limite inferior del valor ingresado a 40 y lo hace equivalente a una duración de 1 segundo.
                    else if (VCOMANDS[0] > 100) duracion_Tono = 60;     // Se restringe el limite Superior del valor ingresado a 60 y lo hace equivalente a una duración de 60 segundo.
                    else duracion_Tono = (VCOMANDS[0] - 40);
                    
                    Buzzer.write(50); // Se carga el ancho de pulso a 50 ya que en la 
                                      // Interrupcion se pone a 0   
                    // Se habilita la interrupcion del ticker y se le asigna
                    // La función que ejecutará cuando se genere la interrupción
                    LengthTonoBuzzer.attach(&stopBuzzer,duracion_Tono); // Cargamos el Tiempo(0-60 segundos) ingresado
                                                                        // y se lo Cargamos al Ticker del Buzzer
                                                                        
                    VCOMANDS[9] = (uint8_t) (periodo_Buzzer * 1000); // Almacenamos El resultado del periodo en VCOMANDS[9] para visualizarlo
                                                                     // Y confirmar que el valor sea el correcto
    
    
    
    
    }



void ReadPort()
{

//   if  (SerialPort.readable())
    VCOMANDS[i] = SerialPort.getc();
    i++;
    if(i > 2) i = 0;


}