#include "mbed.h"
#include "Hx711.h"

#define n_muestras 10

DigitalOut led(LED1);

Hx711 LoadCeld(A1, A0, 1, 1.0);

Serial rs232(USBTX, USBRX);    // USB Serial Terminal






float escala = 0.0;
float offset; 
float calibration_factor = 1000; //Ajustar este valor para calibrar el peso exacto
int averageSamples = 300;

int main(void)
{
     
     
    for(int i = 0; i < n_muestras; i++ )
    {
        while(!LoadCeld.is_ready());
        
        offset = ( offset + LoadCeld.readRaw());

    }
    
    offset = (offset / n_muestras);
    LoadCeld.set_offset(offset);
    LoadCeld.set_scale(1.0);
    rs232.printf("Offset: %.2f \n", offset);
    rs232.printf("Offset: %.2f \n", LoadCeld.get_offset());
    offset = 0.0;
    
    //scale.tare(); //Reset the scale to 0
    
    //long zero_factor = scale.averageValue(averageSamples); // Saca promedio de varias lecturas para estabilizar la medida
     
    while (true) {
        
        
        for(int i = 0; i < n_muestras; i++ )
        {
            while(!LoadCeld.is_ready());
            
            escala = ( escala + LoadCeld.read());

        }
        escala = (escala / n_muestras);
        rs232.printf("Peso: %.2f \n", escala); 
        escala = 0.0;
        //scale.setScale(calibration_factor); 
        //float weight = scale.getGram();
        //rs232.printf("Peso: %.2f\n", weight);
        //lcd.locate(0,0);
        //lcd.printf("Peso: %.2f Grms", weight);
        led = !led; // toggle led
        wait(0.2f);
    }
}