#include "mbed.h"
#include "C12832.h"
#include "MMA7660.h"
#include "LM75B.h"

PwmOut red(D5);
PwmOut blue(D8);
PwmOut green(D9);

int i;

C12832 lcd ( D11, D13, D12, D7, D10 );
// testing using PB9 instead of D14: yields "undefined identifier"
MMA7660 MMA ( D14, D15 );  // SDA, SCL (defs stolen from temp sensor demo)
LM75B thermometer ( D14, D15 );

AnalogIn pot1 (A0);
AnalogIn pot2 (A1);

PwmOut spkr(D6);

int main() {
    float temperature;
    float frequency;
    float lnSemitone = log ( 2.0 ) / 12.0f;

    while ( 1 ) {
        // for (i=0; i<8; i++) {
            // red = 1.0 - double ( pot1 );
            // blue = i & 2;
            // green = i & 4;
        // }

        red = MMA.x() * 0.5f + 0.5f;
        green = MMA.y() * 0.5f + 0.5f;
        blue = float ( pot1 );

        lcd.cls();
        lcd.locate ( 1, 1 );
        lcd.printf ( "%5.3f %5.3f %5.3f", MMA.x(), MMA.y(), MMA.z() );
            
        lcd.locate ( 1, 10 );
        temperature = thermometer.read();
        lcd.printf ( "%6.4f degC", temperature );
        
        int pitch = ( ( ( temperature - 21.5f ) * 8.0f ) );
        frequency = exp ( lnSemitone * pitch ) * 440.0f;
        lcd.locate ( 1, 20 );
        lcd.printf ( "p: %3d; f: %6.2f", pitch, frequency );
        spkr.period ( 1.0f / frequency );
        spkr = pot2;  // volume, presumably
 
        wait ( 0.1 );
        
    }
}
