// This file is used to set the current time to the buffer 

#include "mbed.h"
#include "N5110.h"

BusOut leds(LED1,LED2,LED3,LED4);

//         VCC,SCE,RST,D/C,MOSI,SCLK,LED
N5110 lcd(p7,p8,p9,p10,p11,p13,p21);  // LPC1768 - pwr from GPIO
//N5110 lcd(p8,p9,p10,p11,p13,p21);  // LPC1768 - powered from +3V3 - JP1 in 2/3 position
//N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);  // K64F - pwr from 3V3

//------------------------TMP102 START-----------------
// addresses for ADD0 connected to GND
#define TMP102_ADD 0x48
#define TMP102_R_ADD 0x91
#define TMP102_W_ADD 0x90

// register addresses
#define TEMP_REG 0x00
#define CONFIG_REG 0x01
#define THIGH_REG 0x02
#define TLOW_REG 0x03


I2C tmp102(p28,p27); // SDA, SCL


// hang in infinite loop flashing error code
void error(int code)
{
    while(1) {
        leds = 0;
        wait(0.25);
        leds = code;
        wait(0.25);
    }
}

void initTMP102()
{
    tmp102.frequency(400000); // set bus speed to 400 kHz
    int ack; // used to store acknowledgement bit
    char data[2]; // array for data
    char reg = CONFIG_REG; // register address
//////// Read current status of configuration register ///////
    ack = tmp102.write(TMP102_W_ADD,&reg,1); // send the slave write address and the configuration register address
    if (ack)
        error(1); // if we don't receive acknowledgement, flash error message
    ack = tmp102.read(TMP102_R_ADD,data,2); // read default 2 bytes from configuration register and store in buffer
    if (ack)
        error(2); // if we don't receive acknowledgement, flash error message
///////// Configure the register //////////
// set conversion rate to 1 Hz
    data[1] |= (1 << 6); // set bit 6
    data[1] &= ~(1 << 7); // clear bit 7
//////// Send the configured register to the slave ////////////
    char tx_data[3] = {reg,data[0],data[1]}; // create 3-byte packet for writing (p12 datasheet)
    ack = tmp102.write(TMP102_W_ADD,tx_data,3); // send the slave write address, config reg address and contents
    if (ack)
        error(3); // if we don't receive acknowledgement, flash error message
}

float getTemperature()
{
    int ack; // used to store acknowledgement bit
    char data[2]; // array for data
    char reg = TEMP_REG; // temperature register address
    ack = tmp102.write(TMP102_W_ADD,&reg,1); // send temperature register address
    if (ack)
        error(5); // if we don't receive acknowledgement, flash error message
    ack = tmp102.read(TMP102_R_ADD,data,2); // read 2 bytes from temperature register and store in array
    if (ack)
        error(6); // if we don't receive acknowledgement, flash error message
    int temperature = (data[0] << 4) | (data[1] >> 4);
    return temperature*0.0625;
}

//--------------------------TMP102 END-----------------------

void setTime();    // function to set the UNIX time

//--------------------------set time-----------------------
void setTime() {
    int year=2018;
    int mon=12;
    int day=11;
    int hour=14;
    int min=0;
    int sec=0;

struct tm timeinfo;
    timeinfo.tm_year=year-1900;
    timeinfo.tm_mon=mon-1;
    timeinfo.tm_mday=day;
    timeinfo.tm_hour=hour;
    timeinfo.tm_min=min;
    timeinfo.tm_sec=sec;

    // update the time
    time_t current=mktime(&timeinfo);
    set_time(current);
}
//-------------------------set time end--------------------

int main()
{
    
    initTMP102(); // initial TMP102

    // first need to initialise display
    lcd.init();

    // change set contrast in range 0.0 to 1.0
    // 0.5 appears to be a good starting point
    lcd.setContrast(0.5);


    char buffert[30];  // buffer used to store time string
    char bufferd[30];  // buffer used to store date string
    

    setTime();  // initialise time to 1st January 1970




    while(1) {

        // these are default settings so not strictly needed
        lcd.normalMode();      // normal colour mode
        lcd.setBrightness(0.5); // put LED backlight on 50%

        lcd.clear();

        time_t seconds = time(NULL);  // get current time
        // format time into a string (time and date)
        strftime(buffert, 30 , "%X", localtime(&seconds));
        strftime(bufferd, 30 , "%F", localtime(&seconds));
        // print over serial

        wait(1.0);  // delay for a second

        // clear buffer at start of every loop
        // can directly print strings at specified co-ordinates (must be less than 84 pixels to fit on display)
        lcd.printString("Hello, Xiang!",0,0);

        char buffer[14];  // each character is 6 pixels wide, screen is 84 pixels (84/6 = 14)
        // so can display a string of a maximum 14 characters in length
        // or create formatted strings - ensure they aren't more than 14 characters long

        float temperature = getTemperature();  // temperature from TMP102
        int temp = ceil(temperature);
        //int temp_test = 27;

        //int length = sprintf(buffer,"T = %d C",temp_test); // print formatted data to buffer
        int length = sprintf(buffer,"T = %2d C",temp); // print formatted data to buffer
        // it is important the format specifier ensures the length will fit in the buffer
        if (length <= 14)  // if string will fit on display (assuming printing at x=0)
            lcd.printString(buffer,0,1);           // display on screen

        lcd.printString(buffert, 0, 2); 
        lcd.printString(bufferd, 0, 3); 

        lcd.refresh();
    }
}
