
#ifndef __DIGITALOUTEX_H__
#define __DIGITALOUTEX_H__

#include "mbed.h"
#include "rtos.h"

/** DigitalOutEx
  *
  * This class provides an extended version of DigitalOut that
  * adds a toggle() function, and uses the RTOS Thread API to
  * provide flashing services.
  */
class DigitalOutEx : public DigitalOut {
public:
    /** Construct a new DigitalOutEx object.
      * @param pin The pin to control, e.g. LED1.
      */
    DigitalOutEx(PinName pin);

    /** Set the state of the pin.
      * @param value The state to write; 0 or 1.
      */
    void write(int value);
    
    /** Toggle the state of the pin. */      
    void toggle() { write(!read()); }
    
    /** Start 'flashing' the pin.  
      * This will toggle the state of the pin at the given
      * interval.  To stop flashing, simply set the state
      * of the pin.  Flashing is performed in an RTOS Thread.
      * @param intervalMs The interval to flash in milliseconds.
      */
    void flash(int intervalMs = 200);
    
    /** Return 1 if the pin is currently being 'flashed'
      * (toggled).
      */
    int is_flashing() { return _flashing; }
    
    /** Stop the pin from 'flashing' if it is currently doing so.
      * The pin will be left in its current state (can be 
      * determined with read()).
      */    
    void stop_flashing();
    
    /** Set the state of the pin.  Shorthand for write(). 
      * @param value The state to write; 0 or 1.
      */
    DigitalOutEx &operator=(int value);

protected:
    Thread *_flashThread;
    int _flashing;
    int _flashInterval;
    
    static void _flash_thread(const void *argument);
};

#endif
