
#include "DigitalOutEx.h"

DigitalOutEx::DigitalOutEx(PinName pin)
    : DigitalOut(pin), 
      _flashThread(NULL),
      _flashing(0),
      _flashInterval(200) {  
}

void DigitalOutEx::write(int value) {
    DigitalOut::write(value);
    if (_flashing) {
        stop_flashing();
    }
}

void DigitalOutEx::flash(int intervalMs) {
    _flashInterval = intervalMs;
    if (_flashing) return;
        
    _flashThread = new Thread(DigitalOutEx::_flash_thread, this);        
}

void DigitalOutEx::stop_flashing() {
    if (!_flashing) return;
    
    if (_flashThread != NULL) {
        _flashThread->terminate();
        delete _flashThread;
        _flashThread = NULL;
    }
    _flashing = 0;
}

DigitalOutEx &DigitalOutEx::operator=(int value) {    
    write(value);
    return *this;
}

void DigitalOutEx::_flash_thread(const void *argument) {
    DigitalOutEx *out = (DigitalOutEx *)argument;
    out->_flashing = 1;
    while (1) {
        // use the base class, as DigitalOutEx's write() stops the flashing for us
        ((DigitalOut *)out)->write(!out->read());        
        Thread::wait(((DigitalOutEx *)argument)->_flashInterval);
    }
}