//
//  DB_LCD20x4 Program
//          Nov 7th,2010  Started
//          
//

#include "mbed.h"
#include "TextLCD.h"


#define PERIOD 0.1              // refresh period of measurement

DigitalOut myled1(LED1);        // Assign LED output port LED1 to LED4
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);
InterruptIn button(p25);

Timer timer;
long var;
long count;
long hertz;
int pos = 0;
int array[100];

TextLCD lcd(p24, p26, p27, p28, p29, p30, TextLCD::LCD20x4); // rs,e,d0,d1,d2,d3,20 char's x 4 lines

void flip() {
    myled4 = !myled4;
    array[pos] = timer.read_us();
    timer.reset();
    timer.start();
    pos++;
    if (pos == 100) {
        pos = 0;
    }
}

int main() {
    float tim;
    pos = 0;
    int i;
    for (i=0; i<100; i++) {
        array[i] = 0;
    }

    set_time(1290443600); // 22 Nov 2010 - 16H33

    lcd.cls();
    lcd.locate(0, 0);
    //          0        1         2
    lcd.printf(" LCD Frequencemeter ");
    lcd.locate(0, 1);
    lcd.printf("LCD 20x4 test progrm");
    lcd.locate(0, 2);
    time_t seconds = time(NULL);
    lcd.printf("%s", ctime(&seconds));
    lcd.locate(0, 3);
    lcd.printf("(c) Dominique Bultez");
    wait(2);
    lcd.cls();
    lcd.locate(0, 0);
    lcd.printf(" LCD Frequencemeter ");
    lcd.locate(0, 3);
    lcd.printf("(c) Dominique Bultez");

    timer.reset();
    button.rise(&flip); // attach the address of the flip function to the rising edge
    var = 0;
    tim = PERIOD;

    while (1) {
        for (i=0; i<100; i++) {
            var = var + array[i];
        }
        count = var / 100;          // moyenne de 100 &#65533;chantillons
        hertz = 1000000/count;
        var = 0;
        myled1 = 1;
        wait(tim);
        myled1 = 0;
        myled2 = 1;
        wait(tim);
        myled2 = 0;
        myled3 = 1;
        wait(tim);
        myled3 = 0;

        //lcd.cls();
        //lcd.locate(0, 0);   // 1st line top
        //          0        1         2
        //          12345678901234567890
        //lcd.printf(" LCD Frequencemeter ");
        lcd.locate(0, 1);   // 2nd line
        lcd.printf("%d uSec   ", count);
        lcd.locate(0, 2);
        lcd.printf("%d Hz     ", hertz);
        //lcd.locate(0, 3);
        //lcd.printf("(c) Dominique Bultez");
    }
}