#include "RA8875.h"
#include <string>
#include <stdlib.h>
#include <time.h>
#include "BNO055.h"


#define MOSI    PC_12
#define MISO    PC_11
#define SCLK    PC_10
#define CS      PA_15
#define RST     PD_0

DigitalIn   INT(PD_1);
BNO055 imu(PB_7,PB_6);
DigitalOut G0(PG_0);
DigitalOut bno_enable(PB_5);

Adafruit_RA8875 lcd = Adafruit_RA8875(MOSI, MISO, SCLK, CS, RST);
uint16_t tx, ty;
char * toString(uint16_t number);
Serial pc(USBTX, USBRX); // tx, rxSerial pc(USBTX, USBRX); // tx, rx
void menu();
void menu1();
void menu2();
bool buttonState(uint16_t xMin, uint16_t yMin, uint16_t xMax, uint16_t yMax);
bool notificationState = true;
bool refresh = false;
uint16_t menuVal = 0;



class button{
 public:
    uint16_t x;
    uint16_t y;
    uint16_t w;
    uint16_t h;
    uint16_t textY;
    bool state;
    const char* buttonName;
    bool debounceState;
    
    void update(){
        state = buttonState(x, y, x+w, y+h);
    }
    void create(){
        /*char char_array[buttonName.length()];
        for (int i = 0; i < sizeof(char_array); i++) { 
            char_array[i] = buttonName[i]; 
        } */
        lcd.textEnlarge(1);
        if(debounceState == 0){
            lcd.boxDraw(x,y,w,h,1,GREY,BLUE);
            lcd.textWritePro(x+2,textY,WHITE,BLUE, buttonName );
        }
        if(debounceState == 1){
            lcd.boxDraw(x,y,w,h,1,GREY,GREEN);
            lcd.textWritePro(x+2,textY,WHITE,GREEN, buttonName );
        }
        
    }

};

button menu1_Button;
button menu2_Button;
button relay1_Button;
button relay2_Button;
button relay3_Button;
button relay4_Button;
button relay5_Button;
button relay6_Button;
button relay7_Button;
button relay8_Button;
button relay9_Button;
button settings_Button;


void setup()
{
    bno_enable = 1;
    pc.baud(9600);
    pc.printf("RA8875 start\n");
    imu.reset();
    if (!imu.check()){
        while (true){
            G0 = !G0;
            wait(0.1);
        }
    }
    imu.setmode(OPERATION_MODE_NDOF);
    imu.get_calib();
}

int main()
{
    lcd.begin(RA8875_800x480);
    lcd.displayOn(true);
    lcd.GPIOX(true);      // Enable lcd - display enable tied to GPIOX
    lcd.PWM1config(true, RA8875_PWM_CLK_DIV1024); // PWM output for backlight
    lcd.PWM1out(255);
    lcd.fillScreen(BLACK);
    lcd.touchEnable(true);


    
    lcd.graphicsMode();
    lcd.drawPixel(50,200,WHITE);
    menu();
    menu1();

    float xScale = 1024.0F/lcd.width();
    float yScale = 1024.0F/lcd.height();
    bool INT = 1;

    while(1) {
        if (INT == !1);
        {
            if (lcd.touched()) {
                lcd.touchRead(&tx, &ty);
                //lcd.fillCircle((uint16_t)(tx/xScale), (uint16_t)(ty/yScale), 1, WHITE);
                lcd.textEnlarge(1.2);
                uint16_t tmp;
                tmp = (uint16_t)(tx/xScale);
                
                imu.get_angles();
                pc.printf("%0z %5.1d %5.1d %5.1d\r\n",imu.calib,imu.euler.roll,imu.euler.pitch,imu.euler.yaw);
                tmp = (uint16_t)(abs(imu.euler.pitch));
                wait(0.1);
                char arr[7];
                arr[0] = tmp/100; 
                tmp = tmp - arr[0]*100;
                arr[1] = tmp/10; 
                tmp = tmp - arr[1]*10;
                arr[2] = tmp+48;
                arr[1]+=48;
                arr[0]+=48;
                lcd.textWritePro(10, 450, GREEN, 0, arr);
                tmp = (uint16_t)(ty/yScale);
                arr[3] = ',';
                arr[4] = tmp/100; 
                tmp = tmp - arr[4]*100;
                arr[5] = tmp/10; 
                tmp = tmp - arr[5]*10;
                arr[6] = tmp+48;
                arr[5]+=48;
                arr[4]+=48;
                lcd.textWritePro(10, 450, GREEN, 0, arr);
                menu1_Button.update();
                menu2_Button.update();
                relay1_Button.update();
                relay2_Button.update();
                relay3_Button.update();
                relay4_Button.update();
                relay5_Button.update();
                relay6_Button.update();
                relay7_Button.update();
                relay8_Button.update();
                relay9_Button.update();
                if(menu1_Button.state == 1){
                    menuVal = 1;
                    //menu();
                    menu1();
                    lcd.touchRead(&tx, &ty);
                    wait(0.5);
                }
                if(menu2_Button.state == 1){
                    menuVal = 2;
                    //menu();
                    menu2();
                    lcd.touchRead(&tx, &ty);
                    wait(0.5);
                }
                if(relay1_Button.state == 1){
                    relay1_Button.debounceState = !relay1_Button.debounceState;
                    menu2();
                    lcd.touchRead(&tx, &ty);
                    wait(0.5);
                }
                if(relay2_Button.state == 1){
                    relay2_Button.debounceState = !relay2_Button.debounceState;
                    menu2();
                    lcd.touchRead(&tx, &ty);
                    wait(0.5);
                }
                if(relay3_Button.state == 1){
                    relay3_Button.debounceState = !relay3_Button.debounceState;
                    menu2();
                    lcd.touchRead(&tx, &ty);
                    wait(0.5);
                }
                if(relay4_Button.state == 1){
                    relay4_Button.debounceState = !relay4_Button.debounceState;
                    menu2();
                    lcd.touchRead(&tx, &ty);
                    wait(0.5);
                }
                if(relay5_Button.state == 1){
                    relay5_Button.debounceState = !relay5_Button.debounceState;
                    menu2();
                    lcd.touchRead(&tx, &ty);
                    wait(0.5);
                }
                if(relay6_Button.state == 1){
                    relay6_Button.debounceState = !relay6_Button.debounceState;
                    menu2();
                    lcd.touchRead(&tx, &ty);
                    wait(0.5);
                }
                if(relay7_Button.state == 1){
                    relay7_Button.debounceState = !relay7_Button.debounceState;
                    menu2();
                    lcd.touchRead(&tx, &ty);
                    wait(0.5);
                }
                if(relay8_Button.state == 1){
                    relay8_Button.debounceState = !relay8_Button.debounceState;
                    menu2();
                    lcd.touchRead(&tx, &ty);
                    wait(0.5);
                }
                if(relay9_Button.state == 1){
                    relay9_Button.debounceState = !relay9_Button.debounceState;
                    menu2();
                    lcd.touchRead(&tx, &ty);
                    wait(0.5);
                }
                
            }
        }
    }
}
void menu(){
    lcd.rectHelper(0,0,800,480,BLACK,1);
    lcd.textEnlarge(1);
    lcd.textWritePro(10,5,WHITE,0,"NAVARC Solarange");
    lcd.boxDraw(0,45,800,0,4,GREY,BLUE);
    lcd.boxDraw(250,100,30,30,1,GREY,BLUE);
    if(notificationState){
        lcd.rectHelper(60,100,350,300,GREY,1);
        lcd.boxDraw(250,100,30,30,1,GREY,BLUE);
    }
    
    menu1_Button.x = 50;
    menu1_Button.y = 350;
    menu1_Button.w = 300;
    menu1_Button.h = 100;
    menu1_Button.textY = 380;
    menu1_Button.buttonName = "      Menu 1";
    menu1_Button.create();
    
    menu2_Button.x = 450;
    menu2_Button.y = 350;
    menu2_Button.w = 300;
    menu2_Button.h = 100;
    menu2_Button.textY = 380;
    menu2_Button.buttonName = "      Menu 2";
    menu2_Button.create();
}

void menu1(){
    lcd.rectHelper(20,70,750,330,BLACK,1);
    lcd.boxDraw(390,70,400,250,1,WHITE,WHITE);
    lcd.textEnlarge(1);
    lcd.textWritePro(395,80,BLUE,WHITE,"Panel Grubu 1: 75kW");
    lcd.textWritePro(395,110,BLUE,WHITE,"Panel Grubu 2: 75kW");
    lcd.textWritePro(395,140,BLUE,WHITE,"Panel Grubu 3: 75kW");
    lcd.textWritePro(395,170,BLUE,WHITE,"Batarya      : %?");
    lcd.textWritePro(395,200,BLUE,WHITE,"Menzil       : KM");
    lcd.textWritePro(395,230,BLUE,WHITE,"Meyil Acisi  : 22 derece");
    lcd.textWritePro(395,260,BLUE,WHITE,"Trim Acisi   : 11 derece");
    lcd.textWritePro(395,290,BLUE,WHITE,"Donus Acisi  : 125 derece");
    
    lcd.boxDraw(50,70,300,250,0,WHITE,BLUE);
    lcd.drawCircle(50+150,70+125,100,WHITE);
    lcd.drawCircle(50+150,70+125,99,WHITE);
    lcd.drawCircle(50+150,70+125,98,WHITE);
    lcd.drawCircle(50+150,70+125,97,WHITE);
    lcd.drawCircle(50+150,70+125,96,WHITE);
    lcd.textEnlarge(1);
    lcd.textWritePro(67,285,WHITE,BLUE,"HIZ");
    lcd.textEnlarge(4);
    lcd.textWritePro(120+34,25+120,WHITE,BLUE, "220");
    lcd.textEnlarge(2);
    lcd.textWritePro(120+35,120+40+40,WHITE,BLUE, "Knot");
    //string s = to_string(rand() % 10 + 1;)
}
void menu2(){
    lcd.rectHelper(50,70,800,330,BLACK,1);
    //lcd.rectHelper(30,70,770,330,WHITE,1);
    relay1_Button.x = 20;
    relay1_Button.y = 85;
    relay1_Button.w = 140;
    relay1_Button.h = 90;
    relay1_Button.textY = 85+30;
    relay1_Button.buttonName = " Relay 1";
    relay1_Button.create();
    
    relay2_Button.x = 20;
    relay2_Button.y = 205;
    relay2_Button.w = 140;
    relay2_Button.h = 90;
    relay2_Button.textY = 205+30;
    relay2_Button.buttonName = " Relay 2";
    relay2_Button.create();
    
    relay3_Button.x = 175;
    relay3_Button.y = 85;
    relay3_Button.w = 140;
    relay3_Button.h = 90;
    relay3_Button.textY = 85+30;
    relay3_Button.buttonName = " Relay 3";
    relay3_Button.create();
    
    relay4_Button.x = 175;
    relay4_Button.y = 205;
    relay4_Button.w = 140;
    relay4_Button.h = 90;
    relay4_Button.textY = 205+30;
    relay4_Button.buttonName = " Relay 4";
    relay4_Button.create();
    
    relay5_Button.x = 330;
    relay5_Button.y = 85;
    relay5_Button.w = 140;
    relay5_Button.h = 90;
    relay5_Button.textY = 85+30;
    relay5_Button.buttonName = " Relay 5";
    relay5_Button.create();
    
    relay6_Button.x = 330;
    relay6_Button.y = 205;
    relay6_Button.w = 140;
    relay6_Button.h = 90;
    relay6_Button.textY = 205+30;
    relay6_Button.buttonName = " Relay 6";
    relay6_Button.create();
    
    relay7_Button.x = 485;
    relay7_Button.y = 85;
    relay7_Button.w = 140;
    relay7_Button.h = 90;
    relay7_Button.textY = 85+30;
    relay7_Button.buttonName = " Relay 7";
    relay7_Button.create();
    
    relay8_Button.x = 485;
    relay8_Button.y = 205;
    relay8_Button.w = 140;
    relay8_Button.h = 90;
    relay8_Button.textY = 205+30;
    relay8_Button.buttonName = " Relay 8";
    relay8_Button.create();
    
    relay9_Button.x = 640;
    relay9_Button.y = 85;
    relay9_Button.w = 140;
    relay9_Button.h = 90;
    relay9_Button.textY = 85+30;
    relay9_Button.buttonName = " Relay 9";
    relay9_Button.create();
    
    settings_Button.x = 640;
    settings_Button.y = 205;
    settings_Button.w = 140;
    settings_Button.h = 90;
    settings_Button.textY = 205+30;
    settings_Button.buttonName = " Ayarlar";
    settings_Button.create();
    
}

bool buttonState(uint16_t xMin, uint16_t yMin, uint16_t xMax, uint16_t yMax){

    float xScale = 1024.0F/lcd.width();
    float yScale = 1024.0F/lcd.height();
    if((uint16_t)(tx/xScale)>xMin && (uint16_t)(tx/xScale)<xMax){
        if((uint16_t)(ty/yScale)>yMin && (uint16_t)(ty/yScale)<yMax){
            return true;
        }
    }
    return false;
    
}



    