/*
 * TaskMoveToWaypoint.h
 * Copyright (c) 2018, ZHAW
 * All rights reserved.
 */

#ifndef TASK_MOVE_TO_WAYPOINT_H_
#define TASK_MOVE_TO_WAYPOINT_H_

#include <cstdlib>
#include "Controller.h"
#include "Task.h"

/**
 * This is a specific implementation of a task class that moves the robot to a given waypoint.
 */
class TaskMoveToWaypoint : public Task {
    
    public:
        
        static const float  DEFAULT_VELOCITY;   /**< Default velocity value, given in [m/s]. */
        
                    TaskMoveToWaypoint(Controller& controller, float x, float y);
                    TaskMoveToWaypoint(Controller& controller, float x, float y, float velocity);
        virtual     ~TaskMoveToWaypoint();
        virtual int run(float period);
        
    private:
        
        static const float  PI;
        static const float  K;
        
        Controller& controller;         // reference to the controller object to use
        float       x;                  // x coordinate of target position, given in [m]
        float       y;                  // y coordinate of target position, given in [m]
        float       velocity;           // maximum translational velocity, given in [m/s]
        float       initialDistance;    // initial distance to waypoint, given in [m]
};

#endif /* TASK_MOVE_TO_WAYPOINT_H_ */

