/*
 * SerialServer.h
 * Copyright (c) 2018, ZHAW
 * All rights reserved.
 */

#ifndef SERIAL_SERVER_H_
#define SERIAL_SERVER_H_

#include <cstdlib>
#include <string>
#include <mbed.h>
#include "LIDAR.h"
#include "Controller.h"

using namespace std;

/**
 * This class implements a communication server using a serial interface.
 */
class SerialServer {
    
    public:
        
                        SerialServer(RawSerial& serial, LIDAR& lidar, Controller& controller);
        virtual         ~SerialServer();
        
    private:
        
        static const float  PERIOD;
        static const char   INT_TO_CHAR[];
        static const int    BUFFER_SIZE = 64;
        
        RawSerial&      serial;
        LIDAR&          lidar;
        Controller&     controller;
        string          input;
        string          output;
        Ticker          ticker;
        
        void            receive();
        void            transmit();
};

#endif /* SERIAL_SERVER_H_ */

