/*
 * LIDAR.h
 * Copyright (c) 2018, ZHAW
 * All rights reserved.
 */

#ifndef LIDAR_H_
#define LIDAR_H_

#include <cstdlib>
#include <mbed.h>

/**
 * This is a device driver class for the Slamtec RP LIDAR A1.
 */
class LIDAR {
    
    public:
        
                    LIDAR(RawSerial& serial);
        virtual     ~LIDAR();
        short       getDistance(short angle);
        short       getDistanceOfBeacon();
        short       getAngleOfBeacon();
        void        lookForBeacon();
        
    private:
        
        static const unsigned short HEADER_SIZE = 7;
        static const unsigned short DATA_SIZE = 5;
        
        static const char   START_FLAG = 0xA5;
        static const char   SCAN = 0x20;
        static const char   STOP = 0x25;
        static const char   RESET = 0x40;
        
        static const char   QUALITY_THRESHOLD = 10;
        static const short  DISTANCE_THRESHOLD = 10;
        static const short  DEFAULT_DISTANCE = 10000;
        static const short  MIN_DISTANCE = 500;
        static const short  MAX_DISTANCE = 2000;
        static const short  THRESHOLD = 500;
        static const short  WINDOW = 75;
        static const short  MIN_SIZE = 2;
        static const short  MAX_SIZE = 9;
        
        RawSerial&  serial;             // reference to serial interface for communication
        char        headerCounter;
        char        dataCounter;
        char        data[DATA_SIZE];
        short       distances[360];     // measured distance for every angle value, given in [mm]
        short       distanceOfBeacon;   // distance of detected beacon, given in [mm]
        short       angleOfBeacon;      // angle of detected beacon, given in [degrees]
        bool        lookClockwise;      // flag to indicate direction of search algorithm
        
        void        receive();
};

#endif /* LIDAR_H_ */

