/*
 * Controller.h
 * Copyright (c) 2018, ZHAW
 * All rights reserved.
 */

#ifndef CONTROLLER_H_
#define CONTROLLER_H_

#include <cstdlib>
#include <mbed.h>
#include "EncoderCounter.h"
#include "Motion.h"
#include "LowpassFilter.h"

/**
 * This class implements the coordinate transformation, speed control and
 * the position estimation of a mobile robot with differential drive.
 */
class Controller {

    public:
    
                    Controller(PwmOut& pwmLeft, PwmOut& pwmRight, EncoderCounter& counterLeft, EncoderCounter& counterRight);
        virtual     ~Controller();
        void        setTranslationalVelocity(float velocity);
        void        setRotationalVelocity(float velocity);
        float       getActualTranslationalVelocity();
        float       getActualRotationalVelocity();
        void        setX(float x);
        float       getX();
        void        setY(float y);
        float       getY();
        void        setAlpha(float alpha);
        float       getAlpha();
        void        correctPoseWithBeacon(float xActual, float yActual, float xMeasured, float yMeasured);
        
    private:
        
        static const float  PERIOD;
        static const float  PI;
        static const float  WHEEL_DISTANCE;
        static const float  WHEEL_RADIUS;
        static const float  COUNTS_PER_TURN;
        static const float  LOWPASS_FILTER_FREQUENCY;
        static const float  KN;
        static const float  KP;
        static const float  MAX_VOLTAGE;
        static const float  MIN_DUTY_CYCLE;
        static const float  MAX_DUTY_CYCLE;
        static const float  SIGMA_TRANSLATION;
        static const float  SIGMA_ORIENTATION;
        static const float  SIGMA_DISTANCE;
        static const float  SIGMA_GAMMA;
        
        PwmOut&             pwmLeft;
        PwmOut&             pwmRight;
        EncoderCounter&     counterLeft;
        EncoderCounter&     counterRight;
        Motion              translationalMotion;
        Motion              rotationalMotion;
        float               translationalVelocity;
        float               rotationalVelocity;
        float               actualTranslationalVelocity;
        float               actualRotationalVelocity;
        short               previousValueCounterLeft;
        short               previousValueCounterRight;
        LowpassFilter       speedLeftFilter;
        LowpassFilter       speedRightFilter;
        float               desiredSpeedLeft;
        float               desiredSpeedRight;
        float               actualSpeedLeft;
        float               actualSpeedRight;
        float               x;
        float               y;
        float               alpha;
        float               p[3][3];
        Ticker              ticker;
        
        void                run();
};

#endif /* CONTROLLER_H_ */


