#include "mbed.h"

PwmOut myservo1(PB_4);
PwmOut myservo2(PB_10);
PwmOut myservo3(PB_5);
PwmOut myservo4(PB_3);

Serial pc(USBTX, USBRX);
uint8_t n_motor;//variable de motores
uint8_t n_grados;// variable para grados
uint8_t nm;
uint8_t ng;
        uint8_t NM=nm;
        uint8_t NG=ng;


uint32_t degrees2usec(uint8_t grados){
// Retorno el valor en usegundos, donde
//     y − y1 = m(x − x1 )
    if(grados <= 180)
        return int(750+grados*1900/180);// u6
    return 750;
    
}

void config_uart()
{
    pc.baud(9600);
}

void Leer_Datos()
{
    while (pc.getc()!=0XFF); //sincronizacion 
    n_motor= pc.getc();
    n_grados = pc.getc();    
}


void config_servo()
{
    myservo1.pulsewidth_us(2000);
    myservo1.period_ms(20);
    
    myservo2.pulsewidth_us(2000);
    myservo2.period_ms(20);
    
    myservo3.pulsewidth_us(2000);   
    myservo3.period_ms(20);
    
    myservo4.pulsewidth_us(2000);
    myservo4.period_ms(20);
 
}


void mover_servo(uint8_t nm, uint8_t ng)
{
        

        uint32_t dpulse=0;
        dpulse=degrees2usec(ng);

        switch (nm)
        {
        case 1:
            myservo1.pulsewidth_us(dpulse);
        break;
        case 2:
            myservo2.pulsewidth_us(dpulse);
        break;
        case 3:
            myservo3.pulsewidth_us(dpulse);
        break;
        case 4:
            myservo4.pulsewidth_us(dpulse);
        break;
        }   
 }


int main()
{
    config_uart();
    config_servo();
    
    while(1)
    {
        Leer_Datos();
        mover_servo(n_motor, n_grados);
        
    }
}