#ifndef SCOLOR_TCS3200_H
#define SCOLOR_TCS3200_H
#include "mbed.h"
 /* **************************************************************************
 
@fabeltranm 2019
fbeltranm@ecci.edu.co


   datasheet https://www.mouser.com/catalog/specsheets/TCS3200-E11.pdf


    S0      Frequency scaling 
    S1      Frequency scaling 
    S2      Photo diode selection 
    S3      Photo diode selection 
    OutFreq Frequency

       -----------------------------------
      |   ____________     ____________   |
----> |  |            |   |            |  |                ___     ___ 
Light |  | Photodiode |   |   Current  |--|---OUTPUT_FREQ |   |___|   |___
----> |  |   Array    |---|     to     |  |
      |  |            |   |  Frequency |  |
      |  |____________|   |____________|  |
      |       ^  ^             ^  ^       |
       -------|--|-------------|--|-------
              |  |             |  |
             S2 S3            S0  S1
             
SO | S1 | OUTPUT FREQUENCY SCALING |        | S2 | S3 |   PHOTODIODE TYPE   |
 0 | 0  |        power down        |        |  0 | 0  |         Red         |
 0 | 1  |           2%             |        |  0 | 1  |         Blue        |
 1 | 0  |           20%            |        |  1 | 0  |  Clear (no filter)  |
 1 | 1  |           100%           |        |  1 | 1  |         Green       | 
             
******************************************************************************/


#define SCALE_100   1
#define SCALE_20    2
#define SCALE_2     3    
#define POWER_DOWN  4

class scolor_TCS3200 {
  public:
    scolor_TCS3200(PinName s0, PinName s1, PinName s2, PinName s3, PinName s_in);
    float ReadRed();     // retorno el tiempo en alto de OutFreq para Rojo en ns
    float ReadGreen();   // retorno el tiempo en alto de OutFreq para verde en ns
    float ReadBlue();    // retorno el tiempo en alto de OutFreq color azul en ns
    float ReadClear();   // retorno el tiempo en alto de OutFreq sin filtro en ns
    void SetMode(uint8_t mode);
  private:
    DigitalOut _s0;
    DigitalOut _s1;
    DigitalOut _s2;
    DigitalOut _s3;
    DigitalIn _s_in;
    Timer timer;
    float pulsewidth();

};
#endif