#include "mbed.h"
#include "PwmOut.h"
#include "scolor_TCS3200.h"

//VARIABLES DEFINIDAS ESTANDAR.
#define INITELE 0xFF
#define CMD  0x09
#define CMD2 0x00

//SE DEFINEN LOS SERVOS COMO OBJETOS Y SE ASIGNAN LOS PUERTOS.
 
PwmOut myservo1(PA_7);
PwmOut myservo2(PB_3);
PwmOut myservo3(PB_4);
PwmOut myservo4(PB_6);

//SE DEFINEN LOS JOYSTICK COMO OBJETOS Y SE ASIGNAN LOS PUERTOS

AnalogIn joy(A0);
AnalogIn joy1(A1); 
AnalogIn joy2(A2);
DigitalIn bot1(PA_9);
DigitalIn bot2(PC_7);

//SENSOR COMO OBJETO - PUERTOS PARA EL SENSOR
//                     S0,    S1,   S2,   S3,    OUT
scolor_TCS3200 scolor(PA_8, PB_10, PB_9, PB_5, PB_8);



//COMUNICACIÓN SERIAL 
/*
    Leer_Datos() -> TELECOMANDO Y PARAMETRO
    leer_datos() -> FUNCIÓN ESPECIAL PARA EL SENSOR
*/

Serial pc(USBTX, USBRX);
Serial command(USBTX, USBRX);

//VARIABLES DE LECTURAS
uint8_t telecomando;
uint8_t parametro;
uint8_t nm;//variable de motores
uint8_t ng;// variable para grados
uint8_t cmd;// variable Telemetria
uint8_t cmd2;
uint8_t NM; // En el otro codigo nm
uint8_t NG; // En el otro codigo ng
uint32_t dpulse_=0;

//PULSO ACTUAL - PULSO NUEVO. PARA SABER LA POSICIN DE SERVO
uint32_t dpulse_new=0;  
uint32_t dpulse_act; 


//VARIABLE PARA EL JOYSTICK

float vx=0;
float vy=0;
float vz=0;
float grados3 = 90;
float grados1 = 90;
float grados2 =90;
bool pulsador=0;
bool pulsador2=0;

//VARIABLES PARA CADA UNA DE LAS DIFERENTES VELOCIDADES
uint32_t velocidad_1=500;
uint32_t velocidad_2=100;
uint32_t velocidad_3=50;

//FUNCION DE GRADOS. CONVIERTE LA FRECUENCIA EN GRADOS

uint32_t degrees2usec(uint8_t grados){
// Retorno el valor en usegundos, donde
//     y − y1 = m(x − x1 )
    if(grados <= 180)
        return int(750+grados*1900/180);// u6
    return 750;
}

// COMUNICACION UART

void config_uart()
{
    pc.baud(9600);
}


//LEER TELECOMANDO Y PARAMETRO

void Leer_Datos()
{
    while (pc.getc()!=0XFF); //sincronizacion 
    telecomando= pc.getc();//telecomando
    parametro= pc.getc();//parametro (grados y posición)    
    NM= pc.getc();
    NG= pc.getc(); 
}

//CAPTURA DE DATOS UNICAMENTE PARA EL SENDOR

void leer_datos()
{
    while(pc.getc()!= INITELE);
    cmd=pc.getc();
    cmd2=pc.getc();
}


// CONFIGURACION DEL PERIODO Y LA FRECUENCIA.
//VELOCIDAD INICIAL DE LOS MOTORES.

void config_servo()
{
    myservo1.pulsewidth_us(2000);
    myservo1.period_ms(20);
    
    myservo2.pulsewidth_us(2000);
    myservo2.period_ms(20);
    
    myservo3.pulsewidth_us(2000);   
    myservo3.period_ms(20);
    
    myservo4.pulsewidth_us(2000);
    myservo4.period_ms(20);
 
}



//FUNCIONES DE POSICION DEL BRAZO POR TELECOMANDO Y PARAMETRO

//FUNCION PARA IR A HOME.
void home()
{

    myservo2.pulsewidth_us(degrees2usec(50));
    //wait(1);
    myservo3.pulsewidth_us(degrees2usec(150));
    wait(1);
    myservo1.pulsewidth_us(degrees2usec(90));
    wait(1);
    myservo4.pulsewidth_us(degrees2usec(90));
    wait(1);

}


//FUNCION PARA IR AL MATERIAL
void material()
{
    
    myservo2.pulsewidth_us(degrees2usec(120));
  //  wait(1);
    myservo3.pulsewidth_us(degrees2usec(140));
    wait(1);
    myservo1.pulsewidth_us(degrees2usec(10));
    wait(1);
    myservo4.pulsewidth_us(degrees2usec(100));
    wait(1);
}


//FUNCION PARA IR A LA CELDA_1
void celda1()
{
    
    myservo2.pulsewidth_us(degrees2usec(70));
 //   wait(1);
    myservo3.pulsewidth_us(degrees2usec(80));
    wait(1);
    myservo1.pulsewidth_us(degrees2usec(40));
    wait(1);
    myservo4.pulsewidth_us(degrees2usec(40));
    wait(1);
}


//FUNCION PARA IR A LA CELDA_2
void celda2()
{
    
    myservo2.pulsewidth_us(degrees2usec(70));
  //  wait(1);
    myservo3.pulsewidth_us(degrees2usec(80));
    wait(1);
    myservo1.pulsewidth_us(degrees2usec(70));
    wait(1);
    myservo4.pulsewidth_us(degrees2usec(0));
    wait(1);
}


//FUNCION PARA IR A LA CELDA_3
void celda3()
{
    
    myservo2.pulsewidth_us(degrees2usec(70));
 //   wait(1);
    myservo3.pulsewidth_us(degrees2usec(80));
    wait(1);
    myservo1.pulsewidth_us(degrees2usec(100));
    wait(1);
    myservo4.pulsewidth_us(degrees2usec(160));
    wait(1);
}


//FUNCION PARA IR A LA CELDA_4
void celda4()
{
    
    myservo2.pulsewidth_us(degrees2usec(70));
  //  wait(1);
    myservo3.pulsewidth_us(degrees2usec(80));
    wait(1);
    myservo1.pulsewidth_us(degrees2usec(130));
    wait(1);
    myservo4.pulsewidth_us(degrees2usec(70));
    wait(1);
    
}
//FIN DE LAS FUNCIONES DE POSICION


// FUNCION DE PINZA POR TELECOMANDO Y PARAMETRO

void mover_pinza()
{
    if (parametro==01) //abrir pinza
    {
        myservo4.pulsewidth_us(degrees2usec(0));
        pc.printf("0");
     }   
    else if(parametro==02)
    {
        myservo4.pulsewidth_us(degrees2usec(180)); //cerrar pinza
        pc.printf("1");
    }
}
//FIN DE LA FUNCION PARA MOVER LA PINZA

/*
A CONTINUACION, SE DEFINITE TRES DIFERENTES FUNCIONES QUE SERAN LAS QUE GRADUARAN 
LOS DIFERENTES VALORES DE LAS VELOCIDADES.
VELOCIDAD 1. -> BAJA
VELOCIDAD 2. -> MEDIA
VELOCIDAD 3. -> ALTA
*/
// VELOCIDAD 1.
//VELOCIDAD BAJA

void speed_1(uint8_t NM, uint8_t NG)
{

    uint32_t dpulse_new=0;  
    uint32_t dpulse_act;  
    dpulse_new=degrees2usec(NG);
    int i;
    
    
    if (NM==01)
    {
         printf("Entrado_1");
         dpulse_act =(uint32_t)(myservo1.read()*20000);
         printf("act %d new %d \n", dpulse_act,dpulse_new);
         
         if (dpulse_act < dpulse_new)
                for ( i =dpulse_act ; i< dpulse_new; i=i+50){
                    printf("%d\n",i);
                    myservo1.pulsewidth_us(i);
                    wait_ms(velocidad_1);
                }
         else 
                for (i =dpulse_act ; i > dpulse_new; i=i-50){
                    myservo1.pulsewidth_us(i);
                  printf("%d\n",i);
                    wait_ms(velocidad_1);
                }
        
         myservo1.pulsewidth_us(dpulse_new);
    }
    
    if (NM==02)
    {
         printf("Entrado_2");
         dpulse_act =(uint32_t)(myservo2.read()*20000);
         printf("act %d new %d \n", dpulse_act,dpulse_new);
         
         if (dpulse_act < dpulse_new)
                for ( i =dpulse_act ; i< dpulse_new; i=i+50){
                    printf("%d\n",i);
                    myservo2.pulsewidth_us(i);
                    wait_ms(velocidad_1);
                }
         else 
                for (i =dpulse_act ; i > dpulse_new; i=i-50){
                    myservo2.pulsewidth_us(i);
                  printf("%d\n",i);
                    wait_ms(velocidad_1);
                }
        
         myservo2.pulsewidth_us(dpulse_new);
    }
    
    if (NM==03)
    {
         printf("Entrado_3");
         dpulse_act =(uint32_t)(myservo3.read()*20000);
         printf("act %d new %d \n", dpulse_act,dpulse_new);
         
         if (dpulse_act < dpulse_new)
                for ( i =dpulse_act ; i< dpulse_new; i=i+50){
                    printf("%d\n",i);
                    myservo3.pulsewidth_us(i);
                    wait_ms(velocidad_1);
                }
         else 
                for (i =dpulse_act ; i > dpulse_new; i=i-50){
                    myservo3.pulsewidth_us(i);
                  printf("%d\n",i);
                    wait_ms(velocidad_1);
                }
        
         myservo3.pulsewidth_us(dpulse_new);
    }
    
    if (NM==04)
    {
         printf("Entrado_4");
         dpulse_act =(uint32_t)(myservo4.read()*20000);
         printf("act %d new %d \n", dpulse_act,dpulse_new);
         
         if (dpulse_act < dpulse_new)
                for ( i =dpulse_act ; i< dpulse_new; i=i+50){
                    printf("%d\n",i);
                    myservo4.pulsewidth_us(i);
                    wait_ms(velocidad_1);
                }
         else 
                for (i =dpulse_act ; i > dpulse_new; i=i-50){
                    myservo4.pulsewidth_us(i);
                  printf("%d\n",i);
                    wait_ms(velocidad_1);
                }
        
         myservo4.pulsewidth_us(dpulse_new);
    }
    
}

//VELOCIDAD 2
//VELOCIDAD MEDIA

void speed_2(uint8_t NM, uint8_t NG)
{

    uint32_t dpulse_new=0;  
    uint32_t dpulse_act;  
    dpulse_new=degrees2usec(NG);
    int i;
    
    
    if (NM==01)
    {
         printf("Entrado_5");
         dpulse_act =(uint32_t)(myservo1.read()*20000);
         printf("act %d new %d \n", dpulse_act,dpulse_new);
         
         if (dpulse_act < dpulse_new)
                for ( i =dpulse_act ; i< dpulse_new; i=i+50){
                    printf("%d\n",i);
                    myservo1.pulsewidth_us(i);
                    wait_ms(velocidad_2);
                }
         else 
                for (i =dpulse_act ; i > dpulse_new; i=i-50){
                    myservo1.pulsewidth_us(i);
                  printf("%d\n",i);
                    wait_ms(velocidad_2);
                }
        
         myservo2.pulsewidth_us(dpulse_new);
    }
    
    if (NM==02)
    {
         printf("Entrado_6");
         dpulse_act =(uint32_t)(myservo2.read()*20000);
         printf("act %d new %d \n", dpulse_act,dpulse_new);
         
         if (dpulse_act < dpulse_new)
                for ( i =dpulse_act ; i< dpulse_new; i=i+50){
                    printf("%d\n",i);
                    myservo2.pulsewidth_us(i);
                    wait_ms(velocidad_2);
                }
         else 
                for (i =dpulse_act ; i > dpulse_new; i=i-50){
                    myservo2.pulsewidth_us(i);
                  printf("%d\n",i);
                    wait_ms(velocidad_2);
                }
        
         myservo2.pulsewidth_us(dpulse_new);
    }
    
    if (NM==03)
    {
         printf("Entrado_7");
         dpulse_act =(uint32_t)(myservo3.read()*20000);
         printf("act %d new %d \n", dpulse_act,dpulse_new);
         
         if (dpulse_act < dpulse_new)
                for ( i =dpulse_act ; i< dpulse_new; i=i+50){
                    printf("%d\n",i);
                    myservo3.pulsewidth_us(i);
                    wait_ms(velocidad_2);
                }
         else 
                for (i =dpulse_act ; i > dpulse_new; i=i-50){
                    myservo3.pulsewidth_us(i);
                  printf("%d\n",i);
                    wait_ms(velocidad_2);
                }
        
         myservo3.pulsewidth_us(dpulse_new);
    }
    
    if (NM==04)
    {
         printf("Entrado_8");
         dpulse_act =(uint32_t)(myservo4.read()*20000);
         printf("act %d new %d \n", dpulse_act,dpulse_new);
         
         if (dpulse_act < dpulse_new)
                for ( i =dpulse_act ; i< dpulse_new; i=i+50){
                    printf("%d\n",i);
                    myservo4.pulsewidth_us(i);
                    wait_ms(velocidad_2);
                }
         else 
                for (i =dpulse_act ; i > dpulse_new; i=i-50){
                    myservo4.pulsewidth_us(i);
                  printf("%d\n",i);
                    wait_ms(velocidad_2);
                }
        
         myservo4.pulsewidth_us(dpulse_new);
    }
    
}

//VELOCIDAD 3
//VELOCIDAD ALTA

void speed_3(uint8_t NM, uint8_t NG)
{

    uint32_t dpulse_new=0;  
    uint32_t dpulse_act;  
    dpulse_new=degrees2usec(NG);
    int i;
    
    
    if (NM==01)
    {
         printf("Entrado_9");
         dpulse_act =(uint32_t)(myservo1.read()*20000);
         printf("act %d new %d \n", dpulse_act,dpulse_new);
         
         if (dpulse_act < dpulse_new)
                for ( i =dpulse_act ; i< dpulse_new; i=i+50){
                    printf("%d\n",i);
                    myservo1.pulsewidth_us(i);
                    wait_ms(velocidad_3);
                }
         else 
                for (i =dpulse_act ; i > dpulse_new; i=i-50){
                    myservo1.pulsewidth_us(i);
                  printf("%d\n",i);
                    wait_ms(velocidad_3);
                }
        
         myservo1.pulsewidth_us(dpulse_new);
    }
    
    if (NM==02)
    {
         printf("Entrado_10");
         dpulse_act =(uint32_t)(myservo2.read()*20000);
         printf("act %d new %d \n", dpulse_act,dpulse_new);
         
         if (dpulse_act < dpulse_new)
                for ( i =dpulse_act ; i< dpulse_new; i=i+50){
                    printf("%d\n",i);
                    myservo2.pulsewidth_us(i);
                    wait_ms(velocidad_3);
                }
         else 
                for (i =dpulse_act ; i > dpulse_new; i=i-50){
                    myservo2.pulsewidth_us(i);
                  printf("%d\n",i);
                    wait_ms(velocidad_3);
                }
        
         myservo2.pulsewidth_us(dpulse_new);
    }
    
    if (NM==03)
    {
         printf("Entrado_11");
         dpulse_act =(uint32_t)(myservo3.read()*20000);
         printf("act %d new %d \n", dpulse_act,dpulse_new);
         
         if (dpulse_act < dpulse_new)
                for ( i =dpulse_act ; i< dpulse_new; i=i+50){
                    printf("%d\n",i);
                    myservo3.pulsewidth_us(i);
                    wait_ms(velocidad_3);
                }
         else 
                for (i =dpulse_act ; i > dpulse_new; i=i-50){
                    myservo3.pulsewidth_us(i);
                  printf("%d\n",i);
                    wait_ms(velocidad_3);
                }
        
         myservo3.pulsewidth_us(dpulse_new);
    }
    
    if (NM==04)
    {
         printf("Entrado_12");
         dpulse_act =(uint32_t)(myservo4.read()*20000);
         printf("act %d new %d \n", dpulse_act,dpulse_new);
         
         if (dpulse_act < dpulse_new)
                for ( i =dpulse_act ; i< dpulse_new; i=i+50){
                    printf("%d\n",i);
                    myservo4.pulsewidth_us(i);
                    wait_ms(velocidad_3);
                }
         else 
                for (i =dpulse_act ; i > dpulse_new; i=i-50){
                    myservo4.pulsewidth_us(i);
                  printf("%d\n",i);
                    wait_ms(velocidad_3);
                }
        
         myservo4.pulsewidth_us(dpulse_new);
    }
    
}

/*FUNCION PARA SELECCIONAR LA VELOCIDAD, POR MEDIO DEL "PARAMETRO"
EL VALOR DE LA TELEMETRIA SE DEFINIO DENTRO DEL: MAIN()

TELEMETRIA -> 07.

PARA LOS CASOS DE LA SELECCION DE LA VELOCIDAD:

CASE 1: SPEED_1 -> BAJA.
CASE 2: SPEED_2 -> MEDIA.
CASE 3: SPEED_3 -> ALTA.
*/


void selec_speed()
{
    switch (parametro)
    
    {
    case 01:
    printf ("A \n");
    speed_1(NM, NG);
    break;
    
    case 02:
    printf ("B \n");
    speed_2(NM, NG);
    break;
    
    case 03:
    printf ("C \n");
    speed_3(NM, NG); 
    }
    //printf ("%i \n", parametro);
}


// FUNCION PARA OPERAR POR MEDIO DEL JOYSTICK
/*
JOY1. MOTOR 1.
JOY2. MOTOR 2
JOY3. MOTOR 3.
BOT1. MOTOR 4.
*/

void mover_manual()
{
    //JOY_1 -> EJE X
    vx=joy.read();
   if (vx<0.2)
    {
      grados3=grados3-10; 
      myservo1.pulsewidth_us(degrees2usec(grados3));  
      wait(0.1);
      
      if (grados3 <0)
      {
       grados3=0;
      }
    }
    
    if (vx>0.8)
    {
        grados3= grados3+10;
        myservo1.pulsewidth_us(degrees2usec(grados3));
        wait(0.1);
        if (grados3>180)
        {
            grados3=180;
        }
    } 
        pc.printf("%f \n ",grados3);
    
    //JOY_1 -> EJE Y
    vy=joy1.read();
    
    if (vy<0.2)
    {
        grados1=grados1-10;
        myservo2.pulsewidth_us(degrees2usec(grados1));
        wait(0.1);
        
        if (grados1 <0)
        {
        grados1=0;
        }
    }
    
    if (vy>0.8)
    {
        grados1=grados1+10;
        myservo2.pulsewidth_us(degrees2usec(grados1));
        wait(0.1);
        if (grados1 >180)
        {
        grados1=180;
        } 
    }
        pc.printf("%f \n ",grados1);
     
     
     vz=joy2.read();
    if (vz<0.2)
    {
    grados2=grados2-10;
    myservo3.pulsewidth_us(degrees2usec(grados2));
    wait(0.1);  
    
     if (grados2 <0)
        {
        grados2=0;
        } 
    }
     
     if (vz>0.8)
    {
        grados2=grados2+10;
        myservo3.pulsewidth_us(degrees2usec(grados2));
        wait(0.1);
        
        if (grados2 >180)
        {
        grados2=180;
        } 
        
    }
        pc.printf("%f \n ",grados2);
    
    
    bot1.read();
    
    if(bot1.read()==0)
    {
        myservo4.pulsewidth_us(degrees2usec(150));
        pc.printf("0");
        wait(0.1);
    }
    
     if (bot1.read()==1)
    {
        myservo4.pulsewidth_us(degrees2usec(80));
        pc.printf("1");
        wait(0.1);
    }
    
        pc.printf("%d \n ",bot1.read());
}
//FIN DE LA FUNCION DEL JOYSTICK


//SELECCIONAR EL PARAMETRO DEL JOYSTICK
/*
0XFF 0X08 -> TELEMTRIA DEL JOYSTICK
0X01-> PARAMETRO PARA INICIAR MODOMANUAL
0X02-> PARAMETRO PARA SALIR DEL MODO MANUAL
*/


void seleccionar()
{
        while(parametro == 01)
        {
        mover_manual();
        wait(0.5);
        
            if(pc.readable()!=01)
                {
                    //pc.printf("COMPUTADOR \n");
                    break;              
                }   
        }
}


//FUNCIÓN PARA EL SENSOR DE COLORES

void leer_color()
{
    
    //VARIABLES DE ALMACENAMIENTO DEL PERIODO
    
    float     red_sr = scolor.ReadRed();
    float     green_sr = scolor.ReadGreen();
    float     blue_sr = scolor.ReadBlue();
    float     clear_sr = scolor.ReadClear();
 
    //printf("RED: %5d     GREEN: %5d     BLUE: %5d     CLEAR: %5d    \n ", red_sr, green_sr, blue_sr, clear_sr);
    //printf("fRED: %f     fGREEN: %f     fBLUE: %f    fCLEAR: %f    \n ", 1/red_sr, 1/green_sr, 1/blue_sr, 1/clear_sr);
    
    //VARIABLE DE ALAMCENAMIENTO DEL VALOR DE LAS COMPONENTE EN PORCENTAJE DE CADA COLOR
    
    float    porcentajeR=(clear_sr/red_sr*100);
    float    porcentajeG=(clear_sr/green_sr*100);
    float    porcentajeB=(clear_sr/blue_sr*100);

    //printf("RED : %f     GREEN: %f    BLUE: %f   \n ", porcentajeR, porcentajeG, porcentajeB);
    
    // CONDICIONES PARA LOS COLORES
    
    /*
    NO SE DESEEA VIDUALIZAR EL NOMBRE DEL COLOR POR LO CUAL SE REALIZO UNA REPRESENTACIÓN
    
    0XFE 0X01-> ROJO 
    0XFE 0X02-> AZUL
    0XFE 0X03-> VERDE
    0XFE 0X04-> AMARILLO 
    0XFE 0X05-> NINGUN COLOR
    */
    
    if (porcentajeR > porcentajeB && porcentajeB > porcentajeG)
    {
       printf("0XFE 0X01 \n");
       //printf("Rojo \n");
    }
    
    else if (porcentajeB > porcentajeG && porcentajeG > porcentajeR)
    {
        printf("0XFE 0X02 \n");
        //printf("AZUL \n");
    }
    
    else if (porcentajeG > porcentajeR && porcentajeB > porcentajeR)
    {
        printf("0XFE 0X03 \n");
        //printf("VERDE \n");
    }
    
    
    else if (porcentajeR > porcentajeG && porcentajeG > porcentajeB)
    {
     printf("0XFE 0X04 \n");
     //printf("AMARILLO \n");   
    }
    
    else 
    {
        printf("0XFE 0X05 \n");
        //printf("No es ningun color \n");
    }
} 

//FIN DE LA FUNCION PARA LA LECTURA DEL COLOR POR MEDIO DEL SENSOR
 
 
 
//CASOS PARA LOS PARAMETROS DE LAS RUTINAS
/*
ESTE SWITCH FUNCIONA UNICAMENTE PARA INVOCAR LAS RUTINAS DE POSICIÓN DEL ROBOT
0X01-> HOME
0X02-> MATERIAL
0X03-> CELDA 1
0X04-> CELDA 2
0X05-> CELDA 3
0X06-> CELDA 4
*/


void mover_pos()
{    switch(parametro)
                {
                    case 01:
                    pc.printf("a");
                    wait(2);
                    home();
                    break;
                    
                    case 02:
                    pc.printf("b");
                    wait(2);
                    material();
                    break;
                    
                    case 03:
                    pc.printf("c");
                    wait(2);
                    celda1();
                    break;
                    
                    case 04:
                    pc.printf("d");
                    wait(2);
                    celda2();                    
                    break;
                    
                    case 05:
                    pc.printf("e");
                    wait(2);
                    celda3();
                    break;
                    
                    case 06:
                    pc.printf("f");
                    wait(2);
                    celda4();
                    break;              
    }  
}




//CASOS PARA EL TELECOMANDO 
/*
0X01-> MOVER ROBOT POR PARAMETRO
0X02-> MOVER PINZA POR PARAMETRO
0X03-> MOVER MOTOR 1.
0X04-> MOVER MOTOR 2.
0X05-> MOVER MOTOR 3.
0X06-> MOVER MOTOR 4.
0x07-> VELOCIDAD
0X08-> JOYSTICK
0X09-> SENSOR (SIN EMBARGO, ESE CASO NO SE CONTEMPLA DENTRO DEL SIGUIENTE SWITCH)
 
*/

void mover_servo(uint8_t nm, uint8_t ng)
{
        

        uint32_t dpulse=0;
        dpulse=degrees2usec(parametro);
        
        switch (telecomando)
        {
            case 1:
                mover_pos();
                break;
                
            case 2:
                    mover_pinza();
                    break;
                
            case 3:
            pc.printf("g");
            myservo1.pulsewidth_us(dpulse);
            break;
            
            case 4:
            pc.printf("h");
            myservo2.pulsewidth_us(dpulse);
            break;
            
            case 5:
            pc.printf("i");
            myservo3.pulsewidth_us(dpulse);
            break;
            
            case 6:
            pc.printf("J");
            myservo4.pulsewidth_us(dpulse);
            break;
            
            case 7:
            pc.printf("k");
            selec_speed();
            break;
            
            case 8:
            seleccionar();
            break;
               
        }    
}

//PROGRAMA PRINCIPAL

int main()
{
    //INICIO ESTANDAR.
    myservo1.period_ms(20); // es constante 
    printf("inicio");
    
    config_uart();
    config_servo();
    
    while(1)
    {
        Leer_Datos();
        mover_servo(telecomando, parametro);
        leer_datos();
        if (cmd==CMD)
        {
            if (cmd2==CMD2)
            {
            leer_color();
            }
        }
    }
}




    
    
