#include "mbed.h"
 
PwmOut myservo1(PB_10);
PwmOut myservo2(PB_4);
PwmOut myservo3(PB_5);
PwmOut myservo4(PB_3);

Serial pc(USBTX, USBRX);
uint8_t telecomando;
uint8_t parametro;
uint8_t nm;//variable de motores
uint8_t ng;// variable para grados


uint32_t degrees2usec(uint8_t grados){
// Retorno el valor en usegundos, donde
//     y − y1 = m(x − x1 )
    if(grados <= 180)
        return int(750+grados*1900/180);// u6
    return 750;
}


void config_uart()
{
    pc.baud(9600);
}


void Leer_Datos()
{
    while (pc.getc()!=0XFF); //sincronizacion 
    telecomando= pc.getc();//telecomando
    parametro= pc.getc();//parametro (grados y posición)    
}


void config_servo()
{
    myservo1.pulsewidth_us(2000);
    myservo1.period_ms(20);
    
    myservo2.pulsewidth_us(2000);
    myservo2.period_ms(20);
    
    myservo3.pulsewidth_us(2000);   
    myservo3.period_ms(20);
    
    myservo4.pulsewidth_us(2000);
    myservo4.period_ms(20);
 
}

void home()
{
    myservo1.pulsewidth_us(degrees2usec(90));
    wait(1);
    myservo2.pulsewidth_us(degrees2usec(50));
    wait(1);
    myservo3.pulsewidth_us(degrees2usec(150));
    wait(1);
    myservo4.pulsewidth_us(degrees2usec(90));
    wait(1);

}


void material()
{
    myservo1.pulsewidth_us(degrees2usec(10));
    wait(1);
    myservo2.pulsewidth_us(degrees2usec(120));
    wait(1);
    myservo3.pulsewidth_us(degrees2usec(140));
    wait(1);
    myservo4.pulsewidth_us(degrees2usec(100));
    wait(1);
}


void celda1()
{
    myservo1.pulsewidth_us(degrees2usec(40));
    wait(1);
    myservo2.pulsewidth_us(degrees2usec(70));
    wait(1);
    myservo3.pulsewidth_us(degrees2usec(80));
    wait(1);
    myservo4.pulsewidth_us(degrees2usec(40));
    wait(1);
}


void celda2()
{
    myservo1.pulsewidth_us(degrees2usec(70));
    wait(1);
    myservo2.pulsewidth_us(degrees2usec(70));
    wait(1);
    myservo3.pulsewidth_us(degrees2usec(80));
    wait(1);
    myservo4.pulsewidth_us(degrees2usec(0));
    wait(1);
}


void celda3()
{
    myservo1.pulsewidth_us(degrees2usec(100));
    wait(1);
    myservo2.pulsewidth_us(degrees2usec(70));
    wait(1);
    myservo3.pulsewidth_us(degrees2usec(80));
    wait(1);
    myservo4.pulsewidth_us(degrees2usec(160));
    wait(1);
}


void celda4()
{
    myservo1.pulsewidth_us(degrees2usec(130));
    wait(1);
    myservo2.pulsewidth_us(degrees2usec(70));
    wait(1);
    myservo3.pulsewidth_us(degrees2usec(80));
    wait(1);
    myservo4.pulsewidth_us(degrees2usec(70));
    wait(1);
    
}


void mover_pinza()
{
    if (parametro==01) //abrir pinza
    {
        myservo4.pulsewidth_us(degrees2usec(0));
        pc.printf("0");
     }   
    else if(parametro==02)
    {
        myservo4.pulsewidth_us(degrees2usec(180)); //cerrar pinza
        pc.printf("1");
    }
}

void mover_pos()
{    switch(parametro)
                {
                    case 01:
                    pc.printf("a");
                    home();
                    break;
                    
                    case 02:
                    pc.printf("b");
                    material();
                    break;
                    
                    case 03:
                    pc.printf("c");
                    celda1();
                    break;
                    
                    case 04:
                    pc.printf("d");
                    celda2();                    
                    break;
                    
                    case 05:
                    pc.printf("e");
                    celda3();
                    break;
                    
                    case 06:
                    pc.printf("f");
                    celda4();
                    break;
    }  
}


void mover_servo(uint8_t nm, uint8_t ng)
{
        

        uint32_t dpulse=0;
        dpulse=degrees2usec(parametro);
        
        switch (telecomando)
        {
            case 1:
                mover_pos();
                break;
                
            case 2:
                    mover_pinza();
                    break;
                
            case 3:
            myservo1.pulsewidth_us(dpulse);
            break;
            
            case 4:
            myservo2.pulsewidth_us(dpulse);
            break;
            
            case 5:
            myservo3.pulsewidth_us(dpulse);
            break;
            
            case 6:
            myservo4.pulsewidth_us(dpulse);
            break;   
        }    
}



int main()
{
    config_uart();
    config_servo();
    
    while(1)
    {
        Leer_Datos();
        mover_servo(telecomando, parametro);
        
    }
}