#include "mbed.h"
#include "rtos.h"
#include "C12832.h"
#include "MMA7660.h"

// Define the mutex
Mutex lcd_mutex;
Mutex acc_mutex;

PwmOut      led(D9);
AnalogIn    pot1(A0);
C12832      lcd(D11, D13, D12, D7, D10);
MMA7660     MMA(D14, D15);

// Adjust the brightness of the LED
void adjust_brightness(void const *args){
    while(1){
        led = 1 - pot1.read();
        Thread::wait(50);
    }
}

//Display LED brightness on the LCD
void disp_led_thread(void const *args){
    while(1){
        lcd_mutex.lock();
        lcd.locate(0, 0);
        lcd.printf("Brightness: %.2f", 1 - led);
        lcd_mutex.unlock();
        Thread::wait(100);
    }
}

// Display acceleration x on the LCD
void disp_x_thread(void const *args){
    while(1){
        lcd_mutex.lock();
        acc_mutex.lock();
        lcd.locate(0, 8);
        lcd.printf("x=%.2f", MMA.x());
        acc_mutex.unlock();
        lcd_mutex.unlock();
        Thread::wait(100);
    }
}

// Display acceleration y on the LCD
void disp_y_thread(void const *args){
    while(1){
        lcd_mutex.lock();
        acc_mutex.lock();
        lcd.locate(40, 8);
        lcd.printf("y=%.2f", MMA.y());
        acc_mutex.unlock();
        lcd_mutex.unlock();
        Thread::wait(100);
    }
}

// Display acceleration z on the LCD
void disp_z_thread(void const *args){
    while(1){
        lcd_mutex.lock();
        acc_mutex.lock();
        lcd.locate(80, 8);
        lcd.printf("z=%.2f", MMA.z());
        acc_mutex.unlock();
        lcd_mutex.unlock();
        Thread::wait(100);
    }
}

int main()
{
    lcd.cls();

    Thread thread1(adjust_brightness);
    Thread thread2(disp_led_thread);
    Thread thread3(disp_x_thread);
    Thread thread4(disp_y_thread);
    Thread thread5(disp_z_thread);

    // Sleep and wait for interrupt
    while (1) {
        __wfi();
    }
}
