#include "mbed.h"
#include "C12832.h"

// 添加MMA7660库文件
#include "MMA7660.h"

PwmOut led(D5);
DigitalIn button_up(A2);
DigitalIn button_center(D4);
DigitalIn button_down(A3);
C12832 lcd(D11, D13, D12, D7, D10);

// 初始化MMA7660
MMA7660 MMA(D14, D15);

double brightness = 1.0;
double brightness_inc = 0.1;

int main()
{
    int bt_flag = 0;
    lcd.cls();
    led.write(brightness);

    while (1) {
        bt_flag = 1;
        if(button_up==1)
            brightness -= brightness_inc;
        else if(button_down==1)
            brightness += brightness_inc;
        else if(button_center==1)
            brightness = (brightness>0.5)?1.0:0.0;
        else
            bt_flag = 0;
        if(bt_flag==1)
        {
            brightness = (brightness>1.0)?0.0:brightness;
            brightness = (brightness<0.0)?1.0:brightness;
            led.write(brightness);
        }
        lcd.locate(0, 0);
        lcd.printf("Brightness = %.1f\r\n", 1.0 - brightness);
        
        // 显示加速度计的测量结果
        lcd.printf("x=%.2f y=%.2f z=%.2f", MMA.x(), MMA.y(), MMA.z());
        wait(0.2);
    }
}
