#include "mbed.h"

PwmOut led(D5);
InterruptIn button_up(A2);
InterruptIn button_down(A3);

double brightness = 1.0;
double brightness_inc = 0.1;

void press_up()
{
    brightness -= brightness_inc;
}

void press_down()
{
    brightness += brightness_inc;
}

int main()
{
    // Set PWM
    led.write(brightness);
    led.period_ms(1);
    
    button_up.fall(&press_up);
    button_down.fall(&press_down);

    while (1) {
        brightness = (brightness>1.0)?0.0:brightness;
        brightness = (brightness<0.0)?1.0:brightness;
        led.write(brightness);
    }
}
