/**
 * @file app.h
 * File to modify for the semtech workshop demo
 */
 
#ifndef APP_H
#define APP_H

/**
 * This function will be called when a downlink confirmation comes in
 */
void onDownlinkConfirmation();
void onDownlinkUnconfirmed();

/**
 * Initialization function
 */
void start();

/**
 * Application loop
 */
void loop();


void flashLED(uint8_t times);

void flashLEDCallback(void);

void addAlarmData(uint16_t positionArg);

void addRotaryData(uint16_t positionArg);

void transmitData(uint16_t position);

void timerCallback(void);

void checkAlarm(void);

void checkButton(void);

void startHeartbeat(uint8_t time);

void txTimeoutCallback(void);

#endif